/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.player;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.g_skyrim.rpglevel.skills.SkillDefinition;
import org.g_skyrim.rpglevel.skills.SkillRegistry;

public final class PlayerSkills {
    private static final String NBT_KEY = "rpglevel:skills";
    private static final Map<UUID, PlayerSkills> CACHE = new ConcurrentHashMap<UUID, PlayerSkills>();
    private final Map<class_2960, LevelXp> data = new ConcurrentHashMap<class_2960, LevelXp>();
    private int availablePoints = 0;
    private boolean allMaxAnnounced = false;

    public static void bootstrap() {
    }

    public static void clearRuntimeCache() {
        CACHE.clear();
    }

    public static PlayerSkills of(UUID uuid) {
        return CACHE.computeIfAbsent(uuid, k -> new PlayerSkills());
    }

    public void resetAll() {
        this.data.clear();
        this.availablePoints = 0;
    }

    public static void onPlayerClonePersist(class_3222 player, class_2487 nbt) {
        class_2487 root = new class_2487();
        PlayerSkills ps = PlayerSkills.of(player.method_5667());
        for (Map.Entry<class_2960, LevelXp> e : ps.data.entrySet()) {
            class_2487 one = new class_2487();
            one.method_10569("level", e.getValue().level);
            one.method_10544("xp", e.getValue().xp);
            root.method_10566(e.getKey().toString(), (class_2520)one);
        }
        root.method_10569("__points", ps.availablePoints);
        root.method_10556("__allMaxAnnounced", ps.allMaxAnnounced);
        nbt.method_10566(NBT_KEY, (class_2520)root);
    }

    public static void onPlayerReadPersist(class_3222 player, class_2487 nbt) {
        PlayerSkills ps = PlayerSkills.of(player.method_5667());
        if (!nbt.method_10545(NBT_KEY)) {
            ps.resetAll();
            return;
        }
        class_2487 root = nbt.method_10562(NBT_KEY);
        ps.data.clear();
        ps.availablePoints = root.method_10550("__points");
        ps.allMaxAnnounced = root.method_10577("__allMaxAnnounced");
        for (String key : root.method_10541()) {
            if (!key.contains(":")) continue;
            class_2487 one = root.method_10562(key);
            ps.data.put(new class_2960(key), new LevelXp(one.method_10550("level"), one.method_10537("xp")));
        }
    }

    public int getLevel(class_2960 skill) {
        LevelXp lx = this.data.get(skill);
        return lx == null ? 0 : lx.level;
    }

    public long getXp(class_2960 skill) {
        LevelXp lx = this.data.get(skill);
        return lx == null ? 0L : lx.xp;
    }

    public void addXp(class_2960 skill, long amount) {
        Map.Entry<Integer, Long> next;
        SkillDefinition def = SkillRegistry.get(skill).orElse(null);
        if (def == null) {
            return;
        }
        LevelXp lx = this.data.computeIfAbsent(skill, k -> new LevelXp(0, 0L));
        lx.xp = Math.max(0L, lx.xp + amount);
        int newLevel = lx.level;
        while ((next = def.xpCurve().higherEntry(newLevel)) != null && lx.xp >= next.getValue()) {
            newLevel = next.getKey();
        }
        lx.level = Math.min(newLevel, def.maxLevel());
    }

    public void setLevel(class_2960 skill, int level) {
        SkillDefinition def = SkillRegistry.get(skill).orElse(null);
        if (def == null) {
            return;
        }
        LevelXp lx = this.data.computeIfAbsent(skill, k -> new LevelXp(0, 0L));
        lx.level = Math.max(0, Math.min(level, def.maxLevel()));
        long lower = 0L;
        Long req = (Long)def.xpCurve().get(lx.level);
        if (req != null) {
            lower = req;
        }
        long upper = Long.MAX_VALUE;
        Map.Entry<Integer, Long> next = def.xpCurve().higherEntry(lx.level);
        if (next != null) {
            upper = Math.max(lower, next.getValue() - 1L);
        }
        lx.xp = Math.max(lower, Math.min(lx.xp, upper));
    }

    public int getAvailablePoints() {
        return this.availablePoints;
    }

    public static final class LevelXp {
        public int level;
        public long xp;

        public LevelXp(int level, long xp) {
            this.level = level;
            this.xp = xp;
        }
    }
}

