/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.restrictions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.g_skyrim.rpglevel.network.RestrictionNoticePacket;
import org.g_skyrim.rpglevel.player.PlayerSkills;
import org.g_skyrim.rpglevel.restrictions.model.RestrictionRule;
import org.g_skyrim.rpglevel.util.RpgLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestrictionEngine {
    private static final RestrictionEngine INSTANCE = new RestrictionEngine();
    private final List<RestrictionRule> rules = new CopyOnWriteArrayList<RestrictionRule>();

    private RestrictionEngine() {
    }

    public static void bootstrap() {
        RpgLogger.info("RestrictionEngine ready (awaiting config load).");
    }

    public static RestrictionEngine get() {
        return INSTANCE;
    }

    public void clearAndAddAll(Collection<RestrictionRule> newRules) {
        this.rules.clear();
        this.rules.addAll(newRules);
        RpgLogger.info("Loaded " + this.rules.size() + " restriction rules.");
    }

    public boolean onBlockBreak(class_1937 world, class_1657 player, class_2680 state) {
        if (world.field_9236) {
            return true;
        }
        RestrictionRule match = this.findMatchForBlock(state, RestrictionRule.Action.BREAK_BLOCK);
        if (match == null) {
            return true;
        }
        if (this.checkRequirements((class_3222)player, match)) {
            return true;
        }
        this.deny((class_3222)player, match);
        return false;
    }

    public class_1271<class_1799> onUseItem(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) {
            return class_1271.method_22430((Object)stack);
        }
        RestrictionRule match = this.findMatchForItem(stack.method_7909(), RestrictionRule.Action.USE_ITEM);
        if (match == null) {
            return class_1271.method_22430((Object)stack);
        }
        if (world.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        if (this.checkRequirements((class_3222)player, match)) {
            return class_1271.method_22430((Object)stack);
        }
        this.deny((class_3222)player, match);
        return class_1271.method_22431((Object)stack);
    }

    public class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos) {
        RestrictionRule match;
        RestrictionRule itemRule;
        class_2680 state = world.method_8320(pos);
        class_1799 held = player.method_5998(hand);
        if (!held.method_7960() && (itemRule = this.findMatchForItem(held.method_7909(), RestrictionRule.Action.USE_BLOCK)) != null) {
            boolean hasBlockFilter;
            boolean bl = hasBlockFilter = !itemRule.blockIds().isEmpty() || !itemRule.blockTags().isEmpty();
            if (!hasBlockFilter || this.matchesIdAndTags(class_7923.field_41175.method_10221((Object)state.method_26204()), itemRule.blockIds(), itemRule.blockTags(), (class_2378)class_7923.field_41175, (Object)state.method_26204())) {
                if (!world.field_9236) {
                    if (!this.checkRequirements((class_3222)player, itemRule)) {
                        this.deny((class_3222)player, itemRule);
                        return class_1269.field_5814;
                    }
                } else {
                    return class_1269.field_5811;
                }
            }
        }
        if ((match = this.findMatchForBlock(state, RestrictionRule.Action.USE_BLOCK)) == null) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (this.checkRequirements((class_3222)player, match)) {
            return class_1269.field_5811;
        }
        this.deny((class_3222)player, match);
        return class_1269.field_5814;
    }

    public class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos) {
        RestrictionRule match;
        RestrictionRule itemRule;
        class_2680 state = world.method_8320(pos);
        class_1799 held = player.method_5998(hand);
        if (!held.method_7960() && (itemRule = this.findMatchForItem(held.method_7909(), RestrictionRule.Action.ATTACK_BLOCK)) != null) {
            if (!world.field_9236) {
                if (!this.checkRequirements((class_3222)player, itemRule)) {
                    this.deny((class_3222)player, itemRule);
                    return class_1269.field_5814;
                }
            } else {
                return class_1269.field_5811;
            }
        }
        if ((match = this.findMatchForBlock(state, RestrictionRule.Action.ATTACK_BLOCK)) == null) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (this.checkRequirements((class_3222)player, match)) {
            return class_1269.field_5811;
        }
        this.deny((class_3222)player, match);
        return class_1269.field_5814;
    }

    public class_1269 onAttackEntity(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) {
            return class_1269.field_5811;
        }
        RestrictionRule match = this.findMatchForItem(stack.method_7909(), RestrictionRule.Action.ATTACK_ENTITY);
        if (match == null) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (this.checkRequirements((class_3222)player, match)) {
            return class_1269.field_5811;
        }
        this.deny((class_3222)player, match);
        return class_1269.field_5814;
    }

    public boolean onEquipItem(class_3222 player, class_1799 newStack) {
        if (newStack.method_7960()) {
            return true;
        }
        RestrictionRule match = this.findMatchForItem(newStack.method_7909(), RestrictionRule.Action.EQUIP_ITEM);
        if (match == null) {
            return true;
        }
        if (this.checkRequirements(player, match)) {
            return true;
        }
        this.deny(player, match);
        return false;
    }

    public RestrictionRule findMatchForItem(class_1792 item, RestrictionRule.Action action) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        RestrictionRule best = null;
        int bestPrimary = Integer.MIN_VALUE;
        int bestSecondary = Integer.MIN_VALUE;
        for (RestrictionRule r : this.rules) {
            int secondary;
            int primary;
            int tagsSize;
            if (r.action() != action || !this.matchesIdAndTags(id, r.itemIds(), r.itemTags(), (class_2378)class_7923.field_41178, (Object)item)) continue;
            int idsSize = r.itemIds() == null ? 0 : r.itemIds().size();
            int n = tagsSize = r.itemTags() == null ? 0 : r.itemTags().size();
            if (idsSize > 0) {
                primary = 1000;
                secondary = -idsSize;
            } else if (tagsSize > 0) {
                primary = 100;
                secondary = tagsSize;
            } else {
                primary = 0;
                secondary = 0;
            }
            if (best != null && primary <= bestPrimary && (primary != bestPrimary || secondary <= bestSecondary)) continue;
            best = r;
            bestPrimary = primary;
            bestSecondary = secondary;
        }
        return best;
    }

    public RestrictionRule findMatchForBlock(class_2680 state, RestrictionRule.Action action) {
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        RestrictionRule best = null;
        int bestPrimary = Integer.MIN_VALUE;
        int bestSecondary = Integer.MIN_VALUE;
        for (RestrictionRule r : this.rules) {
            int secondary;
            int primary;
            int tagsSize;
            boolean hasBlockFilter;
            if (r.action() != action || !(hasBlockFilter = r.blockIds() != null && !r.blockIds().isEmpty() || r.blockTags() != null && !r.blockTags().isEmpty()) || !this.matchesIdAndTags(id, r.blockIds(), r.blockTags(), (class_2378)class_7923.field_41175, (Object)state.method_26204())) continue;
            int idsSize = r.blockIds() == null ? 0 : r.blockIds().size();
            int n = tagsSize = r.blockTags() == null ? 0 : r.blockTags().size();
            if (idsSize > 0) {
                primary = 1000;
                secondary = -idsSize;
            } else if (tagsSize > 0) {
                primary = 100;
                secondary = tagsSize;
            } else {
                primary = 0;
                secondary = 0;
            }
            if (best != null && primary <= bestPrimary && (primary != bestPrimary || secondary <= bestSecondary)) continue;
            best = r;
            bestPrimary = primary;
            bestSecondary = secondary;
        }
        return best;
    }

    public <T> boolean matchesIdAndTags(class_2960 id, Set<class_2960> ids, Set<class_2960> tags, class_2378<T> registry, T value) {
        if (ids != null && !ids.isEmpty() && !ids.contains(id)) {
            return false;
        }
        if (tags != null && !tags.isEmpty()) {
            for (class_2960 tagId : tags) {
                class_6862 key = class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)tagId);
                class_6880 entry = registry.method_47983(value);
                if (entry == null) {
                    return false;
                }
                if (entry.method_40220(key)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkRequirements(class_3222 player, RestrictionRule rule) {
        if (rule.requirements() == null || rule.requirements().isEmpty()) {
            return true;
        }
        PlayerSkills ps = PlayerSkills.of(player.method_5667());
        for (Map.Entry<class_2960, Integer> e : rule.requirements().entrySet()) {
            if (ps.getLevel(e.getKey()) >= e.getValue()) continue;
            return false;
        }
        return true;
    }

    private void deny(class_3222 player, RestrictionRule rule) {
        PlayerSkills ps = PlayerSkills.of(player.method_5667());
        if (rule.requirements() != null && !rule.requirements().isEmpty()) {
            for (Map.Entry<class_2960, Integer> e : rule.requirements().entrySet()) {
                int req;
                int cur = ps.getLevel(e.getKey());
                if (cur >= (req = e.getValue().intValue())) continue;
                RestrictionNoticePacket.send(player, e.getKey(), req, cur);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"Action restricted"), true);
        }
    }

    private static void mergeReqs(Map<class_2960, Integer> into, RestrictionRule rule) {
        if (rule == null || rule.requirements() == null || rule.requirements().isEmpty()) {
            return;
        }
        for (Map.Entry<class_2960, Integer> e : rule.requirements().entrySet()) {
            into.merge(e.getKey(), e.getValue(), Math::max);
        }
    }

    public Map<class_2960, Integer> collectRequirementsForTooltip(class_1792 item, @Nullable class_2248 block) {
        HashMap<class_2960, Integer> merged = new HashMap<class_2960, Integer>();
        RestrictionRule rEquip = this.findMatchForItem(item, RestrictionRule.Action.EQUIP_ITEM);
        RestrictionRule rUseItem = this.findMatchForItem(item, RestrictionRule.Action.USE_ITEM);
        RestrictionRule rAtkBlockWithItem = this.findMatchForItem(item, RestrictionRule.Action.ATTACK_BLOCK);
        RestrictionRule rAtkEntity = this.findMatchForItem(item, RestrictionRule.Action.ATTACK_ENTITY);
        RestrictionRule rUseBlockWithItem = this.findMatchForItem(item, RestrictionRule.Action.USE_BLOCK);
        if (block != null) {
            try {
                class_2680 def = block.method_9564();
                RestrictionRule rUseBlock = this.findMatchForBlock(def, RestrictionRule.Action.USE_BLOCK);
                RestrictionRule rPlaceBlock = this.findMatchForBlock(def, RestrictionRule.Action.PLACE_BLOCK);
                RestrictionRule rBreakBlock = this.findMatchForBlock(def, RestrictionRule.Action.BREAK_BLOCK);
                RestrictionRule rAtkBlock = this.findMatchForBlock(def, RestrictionRule.Action.ATTACK_BLOCK);
                RestrictionEngine.mergeReqs(merged, rUseBlock);
                RestrictionEngine.mergeReqs(merged, rPlaceBlock);
                RestrictionEngine.mergeReqs(merged, rBreakBlock);
                RestrictionEngine.mergeReqs(merged, rAtkBlock);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        RestrictionEngine.mergeReqs(merged, rEquip);
        RestrictionEngine.mergeReqs(merged, rUseItem);
        RestrictionEngine.mergeReqs(merged, rAtkBlockWithItem);
        RestrictionEngine.mergeReqs(merged, rAtkEntity);
        RestrictionEngine.mergeReqs(merged, rUseBlockWithItem);
        return merged;
    }

    public Map<Integer, List<ViewSpec>> collectRestrictionsForSkill(class_2960 skillId) {
        TreeMap<Integer, List<ViewSpec>> byLevel = new TreeMap<Integer, List<ViewSpec>>();
        for (RestrictionRule r : this.rules) {
            Integer lvl;
            if (r.requirements() == null || r.requirements().isEmpty() || (lvl = r.requirements().get(skillId)) == null) continue;
            ViewSpec spec = RestrictionEngine.getViewSpec(r);
            byLevel.computeIfAbsent(lvl, k -> new ArrayList()).add(spec);
        }
        return byLevel;
    }

    @NotNull
    private static ViewSpec getViewSpec(RestrictionRule r) {
        ArrayList<class_2960> iIds = r.itemIds() == null ? List.of() : new ArrayList<class_2960>(r.itemIds());
        ArrayList<class_2960> bIds = r.blockIds() == null ? List.of() : new ArrayList<class_2960>(r.blockIds());
        ArrayList<class_2960> iTags = r.itemTags() == null ? List.of() : new ArrayList<class_2960>(r.itemTags());
        ArrayList<class_2960> bTags = r.blockTags() == null ? List.of() : new ArrayList<class_2960>(r.blockTags());
        return new ViewSpec(r.action(), iIds, bIds, iTags, bTags);
    }

    public record ViewSpec(RestrictionRule.Action action, List<class_2960> itemIds, List<class_2960> blockIds, List<class_2960> itemTags, List<class_2960> blockTags) {
        public ViewSpec(RestrictionRule.Action action, List<class_2960> itemIds, List<class_2960> blockIds, List<class_2960> itemTags, List<class_2960> blockTags) {
            this.action = action;
            this.itemIds = List.copyOf(itemIds);
            this.blockIds = List.copyOf(blockIds);
            this.itemTags = List.copyOf(itemTags);
            this.blockTags = List.copyOf(blockTags);
        }
    }
}

