/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.util;

import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.g_skyrim.rpglevel.Rpglevel;
import org.g_skyrim.rpglevel.config.RpgGeneralConfig;
import org.g_skyrim.rpglevel.player.PlayerSkills;
import org.g_skyrim.rpglevel.skills.SkillRegistry;

public final class SkillBenefits {
    private static final UUID AGILITY_SPEED_UUID = UUID.fromString("9e1d4e9e-6f6a-4f3d-9c8f-5b1c2b8e0a11");
    private static final UUID HEALING_HEALTH_UUID = UUID.fromString("0d1c1f60-0f64-4a3f-9a2f-8d9c1e2f3a44");
    private static final UUID LUCK_UUID = UUID.fromString("7c2a1b9e-0a4d-4b9b-b3c5-22f4f0f6a9d1");

    private SkillBenefits() {
    }

    public static void apply(class_3222 sp) {
        PlayerSkills ps = PlayerSkills.of(sp.method_5667());
        int agi = ps.getLevel(Rpglevel.SK_AGILITY);
        double speedBonus = Math.min(0.1, (double)agi * 0.002);
        SkillBenefits.applyAdditive(sp, class_5134.field_23719, AGILITY_SPEED_UUID, speedBonus, "rpglevel_agility_speed");
        int heal = ps.getLevel(Rpglevel.SK_HEALING);
        double maxHealthBonus = Math.max(0.0, RpgGeneralConfig.get().benefits.healingExtraHealthMax);
        int maxLvlHeal = SkillRegistry.get(Rpglevel.SK_HEALING).map(def -> def.maxLevel()).orElse(50);
        double perLvlHealth = maxLvlHeal > 0 ? maxHealthBonus / (double)maxLvlHeal : 0.0;
        double extraHealth = Math.min(maxHealthBonus, (double)heal * perLvlHealth);
        SkillBenefits.applyAdditive(sp, class_5134.field_23716, HEALING_HEALTH_UUID, extraHealth, "rpglevel_healing_hearts");
        if (sp.method_6032() > sp.method_6063()) {
            sp.method_6033(sp.method_6063());
        }
        int luckLv = ps.getLevel(Rpglevel.SK_LUCK);
        double extraLuck = Math.min(1.0, (double)luckLv * 0.02);
        SkillBenefits.applyAdditive(sp, class_5134.field_23726, LUCK_UUID, extraLuck, "rpglevel_luck");
    }

    private static void applyAdditive(class_3222 sp, class_1320 attr, UUID uuid, double amount, String name) {
        class_1324 inst = sp.method_5996(attr);
        if (inst == null) {
            return;
        }
        class_1322 prev = inst.method_6199(uuid);
        if (prev != null) {
            inst.method_6202(prev);
        }
        if (amount == 0.0) {
            return;
        }
        inst.method_26837(new class_1322(uuid, name, amount, class_1322.class_1323.field_6328));
    }
}

