/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.Lure.core.events;

import com.Apothic0n.Lure.core.LureSavedData;
import com.Apothic0n.Lure.core.api.CreatureSpawnParameters;
import com.Apothic0n.Lure.core.api.MonsterSpawnParameters;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lure", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEvents {
    public static List<EntityType> affectedMobs = List.of(EntityType.f_20510_, EntityType.f_217012_, EntityType.f_20520_, EntityType.f_20555_, EntityType.f_20517_, EntityType.f_20505_, EntityType.f_20457_, EntityType.f_20504_, EntityType.f_20557_, EntityType.f_20560_, EntityType.f_20452_, EntityType.f_20507_, EntityType.f_20499_, EntityType.f_20514_, EntityType.f_20508_, EntityType.f_147035_, EntityType.f_20490_, EntityType.f_20501_, EntityType.f_20530_, EntityType.f_20562_, EntityType.f_20458_, EntityType.f_20479_, EntityType.f_20524_, EntityType.f_20481_, EntityType.f_20558_, EntityType.f_20566_, EntityType.f_20495_, EntityType.f_20531_, EntityType.f_20511_, EntityType.f_20456_, EntityType.f_20453_, EntityType.f_20526_);
    static List<Map<Block, List<CreatureSpawnParameters>>> creatures = List.of(Map.of(Blocks.f_220864_, List.of(new CreatureSpawnParameters(EntityType.f_20510_, List.of(Blocks.f_50249_), 1), new CreatureSpawnParameters(EntityType.f_217012_, List.of(Blocks.f_220833_), 1))), Map.of(Blocks.f_50440_, List.of(new CreatureSpawnParameters(EntityType.f_20520_, List.of(Blocks.f_50092_), 1), new CreatureSpawnParameters(EntityType.f_20555_, List.of(Blocks.f_50034_, Blocks.f_50359_), 4), new CreatureSpawnParameters(EntityType.f_20517_, List.of(Blocks.f_50249_), 1), new CreatureSpawnParameters(EntityType.f_20505_, List.of(Blocks.f_50053_), 2), new CreatureSpawnParameters(EntityType.f_20457_, List.of(Blocks.f_50335_), 1))), Map.of(Blocks.f_50195_, List.of(new CreatureSpawnParameters(EntityType.f_20504_, List.of(Blocks.f_50092_), 1))), Map.of(Blocks.f_220843_, List.of(new CreatureSpawnParameters(EntityType.f_20557_, List.of(Blocks.f_50092_), 1), new CreatureSpawnParameters(EntityType.f_20560_, List.of(Blocks.f_50335_), 1))), Map.of(Blocks.f_50599_, List.of(new CreatureSpawnParameters(EntityType.f_20452_, List.of(Blocks.f_50685_), 1), new CreatureSpawnParameters(EntityType.f_20507_, List.of(Blocks.f_50571_), 1), new CreatureSpawnParameters(EntityType.f_20499_, List.of(Blocks.f_50035_), 1))), Map.of(Blocks.f_50127_, List.of(new CreatureSpawnParameters(EntityType.f_20514_, List.of(Blocks.f_50016_), 4), new CreatureSpawnParameters(EntityType.f_20517_, List.of(Blocks.f_50249_), 1))), Map.of(Blocks.f_50126_, List.of(new CreatureSpawnParameters(EntityType.f_20514_, List.of(Blocks.f_50016_), 4))), Map.of(Blocks.f_49992_, List.of(new CreatureSpawnParameters(EntityType.f_20517_, List.of(Blocks.f_50249_), 1))), Map.of(Blocks.f_50053_, List.of(new CreatureSpawnParameters(EntityType.f_20508_, List.of(Blocks.f_50016_), 4))), Map.of(Blocks.f_50069_, List.of(new CreatureSpawnParameters(EntityType.f_147035_, List.of(Blocks.f_50092_), 1))), Map.of(Blocks.f_49992_, List.of(new CreatureSpawnParameters(EntityType.f_20490_, List.of(Blocks.f_50037_), 1))));
    static List<List<MonsterSpawnParameters>> monsters = List.of(List.of(new MonsterSpawnParameters(EntityType.f_20501_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20530_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20562_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20458_, List.of(), List.of(Biomes.f_48203_)), new MonsterSpawnParameters(EntityType.f_20479_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20524_, List.of(BiomeTags.f_215817_), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20481_, List.of(), List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_48212_)), new MonsterSpawnParameters(EntityType.f_20558_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215817_, BiomeTags.f_207612_, BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20495_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20501_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20530_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20562_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20458_, List.of(), List.of(Biomes.f_48203_)), new MonsterSpawnParameters(EntityType.f_20524_, List.of(), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20479_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20524_, List.of(), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20524_, List.of(BiomeTags.f_215817_), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20481_, List.of(), List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_48212_)), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20524_, List.of(), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20558_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20501_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20530_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20562_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20458_, List.of(), List.of(Biomes.f_48203_)), new MonsterSpawnParameters(EntityType.f_20524_, List.of(), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20524_, List.of(), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215817_, BiomeTags.f_207612_, BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))), List.of(new MonsterSpawnParameters(EntityType.f_20524_, List.of(), List.of(Biomes.f_48199_)), new MonsterSpawnParameters(EntityType.f_20495_, List.of(BiomeTags.f_215817_), List.of()), new MonsterSpawnParameters(EntityType.f_20566_, List.of(BiomeTags.f_215818_), List.of()), new MonsterSpawnParameters(EntityType.f_20531_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20511_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20456_, List.of(), List.of(Biomes.f_48200_)), new MonsterSpawnParameters(EntityType.f_20453_, List.of(), List.of(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_)), new MonsterSpawnParameters(EntityType.f_20526_, List.of(), List.of(Biomes.f_48207_))));
    static int spawnTick = 20;

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && --spawnTick <= 0) {
            spawnTick = 20;
            Player player = event.player;
            Level level = player.m_9236_();
            BlockPos randomPos = new BlockPos((int)(Math.random() * 128.0 + -1.0 * (Math.random() * 128.0) + player.m_20185_()), 0, (int)(Math.random() * 128.0 + -1.0 * (Math.random() * 128.0) + player.m_20189_()));
            if ((double)(randomPos = new BlockPos(randomPos.m_123341_(), level.m_6924_(Heightmap.Types.WORLD_SURFACE, randomPos.m_123341_(), randomPos.m_123343_()), randomPos.m_123343_())).m_123341_() - player.m_20185_() > 24.0 || (double)randomPos.m_123343_() - player.m_20189_() > 24.0 || (double)randomPos.m_123342_() - player.m_20186_() > 24.0) {
                for (int y = randomPos.m_123342_(); y > level.m_141937_() && !CommonForgeEvents.attemptSpawn(level, new BlockPos(randomPos.m_123341_(), y, randomPos.m_123343_()), false); --y) {
                }
            }
        }
    }

    private static boolean attemptSpawn(Level level, BlockPos pos, boolean isExtra) {
        boolean mobSpawned = false;
        ResourceKey dimension = level.m_46472_();
        BlockState centerState = level.m_8055_(pos);
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        if (pos.m_123342_() < level.m_151558_() - 2 && !centerState.m_280296_() && !aboveState.m_280296_()) {
            List<Block> neighbors = List.of(level.m_8055_(pos.m_122012_()).m_60734_(), level.m_8055_(pos.m_122029_()).m_60734_(), level.m_8055_(pos.m_122019_()).m_60734_(), level.m_8055_(pos.m_122024_()).m_60734_());
            BlockState belowState = level.m_8055_(pos.m_7495_());
            if ((belowState.m_280296_() || belowState.m_60713_(Blocks.f_49991_)) && !belowState.m_60713_(Blocks.f_50752_)) {
                CreatureSpawnParameters creatureSpawnParameters;
                boolean light = level.m_45517_(LightLayer.BLOCK, pos) > 0 || level.m_45517_(LightLayer.SKY, pos) > 0 && level.m_45527_(pos) && level.m_46461_();
                ChunkPos chunkPos = level.m_46745_(pos).m_7697_();
                if (light && dimension.equals((Object)Level.f_46428_) && !LureSavedData.contains((ServerLevel)level, chunkPos)) {
                    creatureSpawnParameters = new CreatureSpawnParameters(EntityType.f_20549_, List.of(Blocks.f_50677_), 4);
                    for (int i = 0; i < creatures.size(); ++i) {
                        List<CreatureSpawnParameters> potentialCreatures = creatures.get(i).get(belowState.m_60734_());
                        if (potentialCreatures == null) continue;
                        i = creatures.size();
                        creatureSpawnParameters = potentialCreatures.get((int)Math.round(Math.random() * (double)(potentialCreatures.size() - 1)));
                    }
                    if ((creatureSpawnParameters.entityType().equals(EntityType.f_20490_) || !centerState.m_60713_(Blocks.f_49990_)) && CommonForgeEvents.matchingBlocks(creatureSpawnParameters.adjacentBlocks(), neighbors, creatureSpawnParameters.amountRequired()) >= creatureSpawnParameters.amountRequired()) {
                        LureSavedData.add((ServerLevel)level, chunkPos);
                        creatureSpawnParameters.entityType().m_262496_((ServerLevel)level, pos, MobSpawnType.NATURAL);
                        creatureSpawnParameters.entityType().m_262496_((ServerLevel)level, pos, MobSpawnType.NATURAL);
                        mobSpawned = true;
                    }
                } else if (dimension.equals((Object)Level.f_46429_) && belowState.m_60713_(Blocks.f_49991_) && !LureSavedData.contains((ServerLevel)level, chunkPos) && CommonForgeEvents.matchingBlocks((creatureSpawnParameters = new CreatureSpawnParameters(EntityType.f_20482_, List.of(Blocks.f_50016_), 4)).adjacentBlocks(), neighbors, creatureSpawnParameters.amountRequired()) >= creatureSpawnParameters.amountRequired()) {
                    LureSavedData.add((ServerLevel)level, chunkPos);
                    creatureSpawnParameters.entityType().m_262496_((ServerLevel)level, pos, MobSpawnType.NATURAL);
                    mobSpawned = true;
                }
                if (!light && !belowState.m_60713_(Blocks.f_49991_)) {
                    List<MonsterSpawnParameters> potentialMonsters = monsters.get(level.m_46941_());
                    int firstChoice = (int)Math.round(Math.random() * (double)(potentialMonsters.size() - 1));
                    MonsterSpawnParameters monsterSpawnParameters = potentialMonsters.get(firstChoice);
                    Holder biome = level.m_204166_(pos);
                    if (!biome.m_203565_(Biomes.f_48215_)) {
                        boolean suitableBiome = false;
                        block1: for (int a = firstChoice; a < potentialMonsters.size(); ++a) {
                            int i;
                            if (suitableBiome) continue;
                            monsterSpawnParameters = potentialMonsters.get(a);
                            for (i = 0; i < monsterSpawnParameters.validBiomes().size(); ++i) {
                                if (!biome.m_203565_(monsterSpawnParameters.validBiomes().get(i))) continue;
                                suitableBiome = true;
                                break;
                            }
                            for (i = 0; i < monsterSpawnParameters.validBiomeTags().size(); ++i) {
                                if (!biome.m_203656_(monsterSpawnParameters.validBiomeTags().get(i))) continue;
                                suitableBiome = true;
                                continue block1;
                            }
                        }
                        boolean ghastSpawnable = true;
                        if (monsterSpawnParameters.entityType().equals(EntityType.f_20453_)) {
                            ghastSpawnable = level.m_46847_(AABB.m_82321_((BoundingBox)new BoundingBox(pos.m_122013_(2).m_122030_(2).m_123341_(), pos.m_123342_(), pos.m_122013_(2).m_122030_(2).m_123343_(), pos.m_122020_(2).m_122025_(2).m_123341_(), pos.m_6630_(4).m_123342_(), pos.m_122020_(2).m_122025_(2).m_123343_()))).allMatch(BlockBehaviour.BlockStateBase::m_60795_);
                        }
                        if (!(!monsterSpawnParameters.entityType().equals(EntityType.f_20562_) && centerState.m_60713_(Blocks.f_49990_) || monsterSpawnParameters.entityType().equals(EntityType.f_20562_) && !centerState.m_60713_(Blocks.f_49990_) || monsterSpawnParameters.entityType().equals(EntityType.f_20562_) && !aboveState.m_60713_(Blocks.f_49990_) || !ghastSpawnable || !suitableBiome || CommonForgeEvents.matchingBlocks(List.of(Blocks.f_50016_), neighbors, 4) < 4)) {
                            if (!isExtra) {
                                CommonForgeEvents.attemptSpawn(level, pos.m_122012_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122029_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122019_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122029_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122012_().m_122029_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122012_().m_122024_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122019_().m_122029_(), true);
                                CommonForgeEvents.attemptSpawn(level, pos.m_122019_().m_122024_(), true);
                            } else {
                                monsterSpawnParameters.entityType().m_262496_((ServerLevel)level, pos, MobSpawnType.NATURAL);
                            }
                            mobSpawned = true;
                        }
                    }
                }
            }
        }
        return mobSpawned;
    }

    public static int matchingBlocks(List<Block> adjacentBlocks, List<Block> neighbors, int maxMatches) {
        int matches = 0;
        for (int a = 0; a < adjacentBlocks.size(); ++a) {
            for (int n = 0; n < neighbors.size(); ++n) {
                if (!adjacentBlocks.get(a).equals(neighbors.get(n)) && (neighbors.get(n).m_49966_().m_280296_() || !adjacentBlocks.contains(Blocks.f_50016_)) || ++matches != maxMatches) continue;
                return matches;
            }
        }
        return matches;
    }
}

