/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.entity;

import com.mrbysco.dabomb.config.BombConfig;
import com.mrbysco.dabomb.registry.BombRegistry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class C4
extends ThrowableItemProjectile {
    public C4(EntityType<? extends C4> entityType, Level level) {
        super(entityType, level);
    }

    protected Item getDefaultItem() {
        return (Item)BombRegistry.C4_ITEM.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? ParticleTypes.SMOKE : new ItemParticleOption(ParticleTypes.ITEM, itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (this.random.nextDouble() <= 0.075) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)BombRegistry.BOMB_PLANTED.get(), SoundSource.NEUTRAL, 0.65f, 1.0f);
        }
    }

    protected void onHitBlock(BlockHitResult hitBlock) {
        this.setNoGravity(true);
        this.setDeltaMovement(new Vec3(0.0, (double)1.0E-4f, 0.0));
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        if (!this.level().isClientSide && this.canHitEntity(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity hitentity = (LivingEntity)entity;
                Entity entity2 = this.getOwner();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)entity2;
                    hitentity.setLastHurtByMob(owner);
                }
            }
            this.startRiding(entity, true);
        }
    }

    public void shootFromRotation(Entity entity, float x, float y, float z, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 vec3 = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, entity.onGround() ? 0.0 : vec3.y, vec3.z));
    }

    public void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625) + 0.5, this.getZ(), ((Double)BombConfig.COMMON.c4Radius.get()).floatValue(), Level.ExplosionInteraction.TNT);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.discard();
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return new Vec3(0.0, 0.5, 0.0);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Tags.Items.TOOLS_SHEAR) && (this.getOwner() == null || player.getUUID().equals(this.getOwner().getUUID()))) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnAtLocation(serverLevel, (ItemLike)BombRegistry.C4_ITEM.get());
            }
            if (this.random.nextDouble() <= 0.075) {
                this.level().playSound(null, this.blockPosition(), (SoundEvent)BombRegistry.BOMB_DEFUSED.get(), SoundSource.NEUTRAL, 0.65f, 1.0f);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
        return super.interact(player, hand);
    }

    public boolean isPickable() {
        return true;
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return false;
    }
}

