/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.entity.goal;

import com.mrbysco.dabomb.entity.C4;
import com.mrbysco.dabomb.item.ThrowableItem;
import com.mrbysco.dabomb.registry.BombRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlantC4Goal
extends Goal {
    private LivingEntity target;
    private final Mob bomberMob;
    private int obstructionTick = 0;
    private int plantingTicker = 20;
    private final BlockPos obsPos = null;

    public PlantC4Goal(Mob demolitionMob) {
        this.bomberMob = demolitionMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.bomberMob.getTarget();
        if (this.target == null || this.target.isDeadOrDying() || !this.bomberMob.getNavigation().isDone() || !(this.bomberMob.getMainHandItem().getItem() instanceof ThrowableItem)) {
            return false;
        }
        BlockPos headPos = BlockPos.containing((double)this.bomberMob.getX(), (double)this.bomberMob.getEyeY(), (double)this.bomberMob.getZ());
        BlockPos relativePos = headPos.relative(this.bomberMob.getDirection());
        this.obstructionTick = this.bomberMob.level().getBlockState(relativePos).isAir() ? 0 : ++this.obstructionTick;
        if (this.obsPos != null) {
            this.bomberMob.getNavigation().moveTo((Entity)this.target, 1.0);
        }
        return this.obstructionTick >= 20;
    }

    public void start() {
        super.start();
        this.bomberMob.getNavigation().stop();
        this.obstructionTick = 0;
    }

    public void stop() {
        super.stop();
        this.obstructionTick = 0;
        this.plantingTicker = 20;
        this.detonateC4();
    }

    public boolean canContinueToUse() {
        return this.target != null && this.plantingTicker != 0;
    }

    public void tick() {
        this.bomberMob.getNavigation().stop();
        this.bomberMob.getLookControl().setLookAt((Entity)this.target);
        if (this.plantingTicker == 20) {
            this.plantC4();
        }
        if (this.plantingTicker > 0) {
            --this.plantingTicker;
        }
    }

    private void plantC4() {
        Level level = this.bomberMob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            C4 c4 = (C4)BombRegistry.C4_ENTITY.get().create((Level)serverLevel, EntitySpawnReason.EVENT);
            if (c4 != null) {
                level.playSound((Entity)((Player)null), this.bomberMob.getX(), this.bomberMob.getY(), this.bomberMob.getZ(), (SoundEvent)BombRegistry.C4_SHOOT.get(), SoundSource.HOSTILE, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                c4.setPosRaw(this.bomberMob.getX(), this.bomberMob.getEyeY() - (double)0.1f, this.bomberMob.getZ());
                c4.setItem(this.bomberMob.getMainHandItem());
                c4.setOwner((Entity)this.bomberMob);
                this.bomberMob.getLookControl().setLookAt((Entity)this.target);
                c4.shootFromRotation((Entity)this.bomberMob, this.bomberMob.getXRot(), this.bomberMob.getYRot(), -20.0f, 0.45f, 1.0f);
                level.addFreshEntity((Entity)c4);
                this.bomberMob.getMainHandItem().shrink(1);
            }
        }
    }

    private void detonateC4() {
        Level level = this.bomberMob.level();
        List<C4> c4s = level.getEntitiesOfClass(C4.class, this.bomberMob.getBoundingBox().inflate(64.0)).stream().filter(c4 -> c4.getOwner() != null && c4.getOwner().getUUID().equals(this.bomberMob.getUUID())).toList();
        if (!c4s.isEmpty() && !level.isClientSide) {
            for (C4 c42 : c4s) {
                c42.explode();
            }
        }
    }
}

