/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.item;

import com.mrbysco.dabomb.entity.C4;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RemoteItem
extends Item {
    public RemoteItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.getCooldowns().addCooldown(itemstack, 20);
        level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        List<C4> c4s = level.getEntitiesOfClass(C4.class, player.getBoundingBox().inflate(64.0)).stream().filter(c4 -> c4.getOwner() != null && c4.getOwner().getUUID().equals(player.getUUID())).toList();
        if (!c4s.isEmpty()) {
            if (!level.isClientSide) {
                for (C4 c42 : c4s) {
                    c42.explode();
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResult.SUCCESS;
        }
        return super.use(level, player, hand);
    }
}

