/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dabomb.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ThrowableItem
extends Item {
    private final Supplier<EntityType<?>> entityTypeSupplier;
    private final Supplier<SoundEvent> soundSupplier;
    private final int cooldown;
    private final float z;
    private final float velocity;
    private final float inaccuracy;

    public ThrowableItem(Item.Properties properties, Supplier<EntityType<?>> entityTypeSupplier, Supplier<SoundEvent> soundSupplier, int cooldown, float z, float velocity, float inaccuracy) {
        super(properties);
        this.entityTypeSupplier = entityTypeSupplier;
        this.soundSupplier = soundSupplier;
        this.cooldown = cooldown;
        this.z = z;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
    }

    public EntityType<?> getProjectile() {
        return this.entityTypeSupplier.get();
    }

    public SoundEvent getSoundEvent() {
        return this.soundSupplier.get();
    }

    public float getZ() {
        return this.z;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        Entity entity;
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.getSoundEvent() != null) {
            level.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), this.getSoundEvent(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        player.getCooldowns().addCooldown(itemstack, this.cooldown);
        if (!level.isClientSide && this.getProjectile() != null && (entity = this.getProjectile().create(level, EntitySpawnReason.SPAWN_ITEM_USE)) instanceof ThrowableItemProjectile) {
            ThrowableItemProjectile projectile = (ThrowableItemProjectile)entity;
            projectile.setPosRaw(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
            projectile.setItem(itemstack);
            projectile.setOwner((Entity)player);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), this.getZ(), this.getVelocity(), this.getInaccuracy());
            level.addFreshEntity((Entity)projectile);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

