/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mrbysco.flatterentities.FlatterEntities;
import com.mrbysco.flatterentities.Reference;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FlatConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    private static boolean isValidResourceLocation(Object object) {
        boolean flag = object instanceof String;
        if (flag) {
            String value = (String)object;
            if (value.isEmpty()) {
                return true;
            }
            return ResourceLocation.tryParse((String)value) != null;
        }
        return false;
    }

    public static boolean isValidOption(Object object) {
        boolean flag = object instanceof String;
        if (flag) {
            String[] splitValue;
            String value = (String)object;
            if (value.isEmpty()) {
                return true;
            }
            if (value.contains(",") && (splitValue = value.split(",")).length == 2) {
                return ResourceLocation.tryParse((String)splitValue[0]) != null && ResourceLocation.tryParse((String)splitValue[1]) != null;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Reference.LOGGER.debug("Loaded Flatter Entities' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Reference.LOGGER.warn("Flatter Entities' config just got changed on the file system!");
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getModId().equals("flatterentities")) {
            FlatterEntities.reloadCache();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<List<? extends String>> entityBlacklist;
        public final ModConfigSpec.ConfigValue<List<? extends String>> entityDimensionWhitelist;
        public final ModConfigSpec.ConfigValue<List<? extends String>> dimensionBlacklist;
        public final ModConfigSpec.BooleanValue invertDimensionBlacklist;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.entityBlacklist = builder.comment("A list of entities that won't show flat ever [Syntax: \"modid:entity\" ]\n[Example: \"minecraft:cow\"]").defineListAllowEmpty("entityBlacklist", () -> Collections.singletonList(""), String::new, FlatConfig::isValidResourceLocation);
            this.entityDimensionWhitelist = builder.comment("A list of entities that will show flat even when a dimension is blacklisted [Syntax: \"modid:entity,modid:dimension\" ]\n[Example: \"minecraft:bee,minecraft:the_nether\"]").defineListAllowEmpty("entityDimensionWhitelist", () -> Collections.singletonList(""), String::new, FlatConfig::isValidOption);
            this.dimensionBlacklist = builder.comment("A list of dimensions that won't have flat entities [Syntax: \"modid:dimension\" ]\n[Example: \"minecraft:the_nether\"]").defineListAllowEmpty("dimensionBlacklist", () -> Collections.singletonList(""), String::new, FlatConfig::isValidResourceLocation);
            this.invertDimensionBlacklist = builder.comment("Invert the Dimension Blacklist").define("invertDimensionBlacklist", false);
            builder.pop();
        }
    }
}

