/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities.mixin.gecko;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.flatterentities.Flattener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@Pseudo
@Mixin(value={GeoEntityRenderer.class})
public abstract class GeoEntityRendererMixin<T extends Entity> {
    @Shadow
    public abstract EntityRenderState getEntityRenderState();

    @Inject(method={"actuallyRender(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/entity/Entity;Lsoftware/bernie/geckolib/cache/object/BakedGeoModel;Lnet/minecraft/client/renderer/RenderType;Lnet/minecraft/client/renderer/MultiBufferSource;Lcom/mojang/blaze3d/vertex/VertexConsumer;ZFIII)V"}, remap=false, locals=LocalCapture.NO_CAPTURE, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", shift=At.Shift.AFTER, ordinal=1)})
    public void flatterActuallyRender(PoseStack poseStack, T entityIn, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTicks, int packedLight, int packedOverlay, int color, CallbackInfo ci) {
        if (entityIn instanceof LivingEntity) {
            Entity entity;
            LivingEntity livingEntity = (LivingEntity)entityIn;
            boolean shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
            float f = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
            float f1 = Mth.rotLerp((float)partialTicks, (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
            if (shouldSit && (entity = entityIn.getVehicle()) instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
                float f2 = f1 - f;
                float f3 = Mth.wrapDegrees((float)f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                }
                f = f1 - f3;
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
            }
            double x = entityIn.getX();
            double z = entityIn.getZ();
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                x -= player.getX();
                z -= player.getZ();
            }
            Flattener.prepareFlatRendering(f, x, z, poseStack, this.getEntityRenderState());
        }
    }
}

