/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.flatterentities.Flattener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin<T extends LivingEntity> {
    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", shift=At.Shift.AFTER, ordinal=1)})
    public void flatterRender(T entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, CallbackInfo cir) {
        boolean shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        float f = Flattener.getYawRotation(entityIn, partialTicks, shouldSit);
        double x = entityIn.getX();
        double z = entityIn.getZ();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            x -= player.getX();
            z -= player.getZ();
        }
        Flattener.prepareFlatRendering(f, x, z, poseStack, entityIn);
    }
}

