/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mrbysco.flatterentities.FlatConfig;
import com.mrbysco.flatterentities.FlatKeybinds;
import com.mrbysco.flatterentities.Flattener;
import com.mrbysco.flatterentities.Keybinds;
import com.mrbysco.flatterentities.Reference;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FlatterEntities
implements ClientModInitializer {
    public void onInitializeClient() {
        AutoConfig.register(FlatConfig.class, Toml4jConfigSerializer::new);
        AutoConfig.getConfigHolder(FlatConfig.class).registerSaveListener((manager, data) -> {
            FlatterEntities.reloadCache();
            return class_1269.field_5811;
        });
        KeyBindingHelper.registerKeyBinding((class_304)FlatKeybinds.KEY_TOGGLE);
        ClientTickEvents.END_CLIENT_TICK.register(Keybinds::onKeyPress);
    }

    public static void reloadCache() {
        class_2960 resourceLocation;
        FlatConfig config = (FlatConfig)AutoConfig.getConfigHolder(FlatConfig.class).getConfig();
        Flattener.entityBlacklist.clear();
        for (String value : config.client.entityBlacklist) {
            if (value.isEmpty()) continue;
            resourceLocation = class_2960.method_12829((String)value);
            if (resourceLocation != null) {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(resourceLocation);
                if (entityType != null) {
                    Flattener.entityBlacklist.add(entityType);
                    continue;
                }
                Reference.LOGGER.error("Invalid entity blacklist value: {}, Unable to locate entity", (Object)value);
                continue;
            }
            Reference.LOGGER.error("Invalid entity blacklist value: {}, Are you sure this is the resource location of the entity?", (Object)value);
        }
        Flattener.entityDimensionWhitelist.clear();
        for (String value : config.client.entityDimensionWhitelist) {
            String[] splitValue;
            if (!value.contains(",") || (splitValue = value.split(",")).length != 2) continue;
            class_2960 entityLocation = class_2960.method_12829((String)splitValue[0]);
            class_2960 worldLocation = class_2960.method_12829((String)splitValue[1]);
            if (entityLocation == null || worldLocation == null) continue;
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityLocation);
            if (entityType != null) {
                class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldLocation);
                List entityList = Flattener.entityDimensionWhitelist.getOrDefault(worldKey, new ArrayList());
                entityList.add(entityType);
                Flattener.entityDimensionWhitelist.put((class_5321<class_1937>)worldKey, entityList);
                continue;
            }
            Reference.LOGGER.error("Invalid entity dimension whitelist value: {}, Unable to locate entity", (Object)value);
        }
        Flattener.dimensionListIsWhitelist = config.client.invertDimensionBlacklist;
        Flattener.dimensionBlacklist.clear();
        for (String value : config.client.dimensionBlacklist) {
            if (value.isEmpty()) continue;
            resourceLocation = class_2960.method_12829((String)value);
            if (resourceLocation != null) {
                class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)resourceLocation);
                Flattener.dimensionBlacklist.add((class_5321<class_1937>)worldKey);
                continue;
            }
            Reference.LOGGER.error("Invalid dimension blacklist value: {}, Are you sure this is the resource location of the dimension?", (Object)value);
        }
    }
}

