/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.commands.ModCommands;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Building;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.IBuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CommandCreateBuilding
implements Command<CommandSourceStack> {
    private static final CommandCreateBuilding CMD = new CommandCreateBuilding();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"createbuilding").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"name", (ArgumentType)ResourceLocationArgument.id()).suggests(ModCommands.getBuildingSuggestionProvider()).then(Commands.argument((String)"floors", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).then(Commands.argument((String)"cellars", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes((Command)CMD)))));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int height;
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        Integer floors = (Integer)context.getArgument("floors", Integer.class);
        Integer cellars = (Integer)context.getArgument("cellars", Integer.class);
        Building building = AssetRegistries.BUILDINGS.get((CommonLevelAccessor)((CommandSourceStack)context.getSource()).getLevel(), name);
        if (building == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("Cannot find building: " + String.valueOf(name) + "!"));
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerLevel level = (ServerLevel)player.level();
        WorldCoordinates pos = (WorldCoordinates)context.getArgument("pos", WorldCoordinates.class);
        BlockPos bottom = pos.getBlockPos((CommandSourceStack)context.getSource());
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        ChunkCoord coord = new ChunkCoord((ResourceKey<Level>)level.dimension(), bottom.getX() >> 4, bottom.getZ() >> 4);
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, dimInfo);
        info.setBuildingType(building, cellars, floors, bottom.getY());
        ChunkPos cp = new ChunkPos(bottom);
        for (int y = height = bottom.getY(); y < level.getMaxBuildHeight(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    level.setBlock(cp.getBlockAt(x, y, z), Blocks.AIR.defaultBlockState(), 2);
                }
            }
        }
        for (int f = -info.cellars; f <= info.getNumFloors(); ++f) {
            BuildingPart part = info.getFloor(f);
            CommandCreateBuilding.generatePart((Level)level, cp, info, part, height);
            part = info.getFloorPart2(f);
            if (part != null) {
                CommandCreateBuilding.generatePart((Level)level, cp, info, part, height);
            }
            height += 6;
        }
        return 0;
    }

    private static void generatePart(Level level, ChunkPos cp, BuildingInfo info, IBuildingPart part, int oy) {
        CompiledPalette compiledPalette = info.getCompiledPalette();
        Palette partPalette = part.getLocalPalette((CommonLevelAccessor)level);
        Palette buildingPalette = info.getBuilding().getLocalPalette((CommonLevelAccessor)level);
        if (partPalette != null || buildingPalette != null) {
            compiledPalette = new CompiledPalette(compiledPalette, partPalette, buildingPalette);
        }
        boolean nowater = part.getMetaBoolean("nowater");
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
        for (int x = 0; x < part.getXSize(); ++x) {
            for (int z = 0; z < part.getZSize(); ++z) {
                char[] vs = part.getVSlice(x, z);
                if (vs == null) continue;
                int rx = cp.getBlockX(x);
                int rz = cp.getBlockZ(z);
                current.set(rx, oy, rz);
                for (char c : vs) {
                    BlockState b = compiledPalette.get(c);
                    if (b == null) {
                        throw new RuntimeException("Could not find entry '" + c + "' in the palette for part '" + part.getName() + "'!");
                    }
                    level.setBlock((BlockPos)current, b, 2);
                    current.setY(current.getY() + 1);
                }
            }
        }
    }
}

