/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.Statistics;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.WorldGenLevel;

public class CommandStats
implements Command<CommandSourceStack> {
    private static final CommandStats CMD = new CommandStats();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"stats").requires(cs -> cs.hasPermission(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)player.level());
        if (dimInfo != null) {
            Statistics statistics = dimInfo.getFeature().getStatistics();
            float averageTime = statistics.getAverageTime();
            long minTime = statistics.getMinTime();
            long maxTime = statistics.getMaxTime();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Average time: " + averageTime + "ms")).withStyle(ChatFormatting.YELLOW), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Min time: " + minTime + "ms")).withStyle(ChatFormatting.YELLOW), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Max time: " + maxTime + "ms")).withStyle(ChatFormatting.YELLOW), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No dimension info found!").withStyle(ChatFormatting.RED));
        }
        return 0;
    }
}

