/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lostcities.varia.WorldTools;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;

public class Tools {
    private static final Set<String> DONE = new HashSet<String>();
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_MAPPER = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            return property.getName() + "=" + this.getName(property, entry.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> comparable) {
            return property.getName(comparable);
        }
    };

    public static String stateToString(BlockState state) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
        if (!state.getValues().isEmpty()) {
            stringbuilder.append('[');
            stringbuilder.append(state.getValues().entrySet().stream().map(PROPERTY_MAPPER).collect(Collectors.joining(",")));
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    public static BlockState stringToState(String s) {
        if (s.contains("[")) {
            try {
                BlockStateParser.BlockResult parser = BlockStateParser.parseForBlock((HolderLookup)WorldTools.getOverworld().holderLookup(Registries.BLOCK), (StringReader)new StringReader(s), (boolean)false);
                return parser.blockState();
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        String converted = BlockStateData.upgradeBlock((String)s);
        Block value = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)converted));
        if (value == null) {
            throw new RuntimeException("Cannot find block: '" + s + "'!");
        }
        return value.defaultBlockState();
    }

    public static <T> T getRandomFromList(RandomSource random, List<T> list, Function<T, Float> weightGetter) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<T> elements = new ArrayList<T>();
        float totalweight = 0.0f;
        for (T pair : list) {
            elements.add(pair);
            totalweight += weightGetter.apply(pair).floatValue();
        }
        float r = random.nextFloat() * totalweight;
        for (Object pair : elements) {
            if (!((r -= weightGetter.apply(pair).floatValue()) <= 0.0f)) continue;
            return (T)pair;
        }
        return (T)elements.get(elements.size() - 1);
    }

    public static <T> T getRandomFromList(Random random, List<T> list, Function<T, Float> weightGetter) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<T> elements = new ArrayList<T>();
        float totalweight = 0.0f;
        for (T pair : list) {
            elements.add(pair);
            totalweight += weightGetter.apply(pair).floatValue();
        }
        float r = random.nextFloat() * totalweight;
        for (Object pair : elements) {
            if (!((r -= weightGetter.apply(pair).floatValue()) <= 0.0f)) continue;
            return (T)pair;
        }
        return null;
    }

    public static Iterable<Holder<Block>> getBlocksForTag(TagKey<Block> rl) {
        DefaultedRegistry registry = BuiltInRegistries.BLOCK;
        return registry.getTagOrEmpty(rl);
    }

    public static boolean hasTag(Block block, TagKey<Block> tag) {
        return BuiltInRegistries.BLOCK.getHolderOrThrow(block.builtInRegistryHolder().key()).is(tag);
    }

    public static int getSeaLevel(LevelReader level) {
        WorldGenLevel wgLevel;
        ChunkSource chunkSource;
        if (level instanceof WorldGenLevel && (chunkSource = (wgLevel = (WorldGenLevel)level).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache scc = (ServerChunkCache)chunkSource;
            return scc.getGenerator().getSeaLevel();
        }
        return level.getSeaLevel();
    }

    public static <T> RecordCodecBuilder<T, List<String>> listOrStringList(String fieldName, String defaultVal, Function<T, List<String>> getter) {
        return Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).optionalFieldOf(fieldName, (Object)Either.left((Object)defaultVal)).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((String)list.get(0))) : Either.right((Object)list)).forGetter(getter);
    }
}

