/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import mcjty.lostcities.varia.ChunkCoord;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class WorldTools {
    public static boolean chunkLoaded(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return world.hasChunkAt(pos);
    }

    public static ServerLevel getOverworld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getLevel(Level.OVERWORLD);
    }

    public static ServerLevel getOverworld(Level world) {
        MinecraftServer server = world.getServer();
        return server.getLevel(Level.OVERWORLD);
    }

    public static ServerLevel loadWorld(ResourceKey<Level> type) {
        ServerLevel world = WorldTools.getWorld(type);
        if (world == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            return server.getLevel(type);
        }
        return world;
    }

    public static ServerLevel getWorld(ResourceKey<Level> type) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getLevel(type);
    }

    public static ServerLevel getWorld(Level world, ResourceKey<Level> type) {
        MinecraftServer server = world.getServer();
        return server.getLevel(type);
    }

    public static Map<Structure, LongSet> checkStructures(ServerLevel level, ChunkCoord coord) {
        BlockPos center = new BlockPos(coord.chunkX() << 12, 60, coord.chunkZ() << 12);
        StructureManager structuremanager = level.structureManager();
        Map structures = structuremanager.getAllStructuresAt(center);
        return structures;
    }
}

