/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.gen.Spheres;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.common.Tags;

public class LostCitySphereFeature
extends Feature<NoneFeatureConfiguration> {
    public LostCitySphereFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        IDimensionInfo diminfo;
        WorldGenLevel level = context.level();
        if (level instanceof WorldGenRegion && (diminfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo(level)) != null) {
            WorldGenRegion region = (WorldGenRegion)level;
            ChunkPos center = region.getCenter();
            Holder biome = region.getBiome(center.getMiddleBlockPosition(60));
            if (biome.is(Tags.Biomes.IS_VOID)) {
                return false;
            }
            int chunkX = center.x;
            int chunkZ = center.z;
            diminfo.setWorld(level);
            Spheres.generateSpheres(diminfo.getFeature(), region, region.getChunk(chunkX, chunkZ));
            return true;
        }
        return false;
    }
}

