/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedSphere;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CitySphere
implements ILostSphere {
    private static final Map<ChunkCoord, CitySphere> CITY_SPHERE_CACHE = new HashMap<ChunkCoord, CitySphere>();
    public static final CitySphere EMPTY = new CitySphere(new ChunkCoord((ResourceKey<Level>)Level.OVERWORLD, 0, 0), 0.0f, new BlockPos(0, 0, 0), false);
    private final ChunkCoord center;
    private final BlockPos centerPos;
    private final float radius;
    private final boolean enabled;
    private boolean monorailNorthCandidate;
    private boolean monorailSouthCandidate;
    private boolean monorailWestCandidate;
    private boolean monorailEastCandidate;
    private BlockState glassBlock = Blocks.AIR.defaultBlockState();
    private BlockState baseBlock = Blocks.AIR.defaultBlockState();
    private BlockState sideBlock = Blocks.AIR.defaultBlockState();

    private CitySphere(ChunkCoord center, float radius, BlockPos centerPos, boolean enabled) {
        this.enabled = enabled;
        this.center = center;
        this.radius = radius;
        this.centerPos = centerPos;
    }

    public static void initSphere(CitySphere sphere, IDimensionInfo provider) {
        if (sphere.getBaseBlock() != Blocks.AIR.defaultBlockState()) {
            return;
        }
        ChunkCoord center = sphere.getCenter();
        BuildingInfo info = BuildingInfo.getBuildingInfo(center, provider);
        CityStyle cs = info.getCityStyle();
        Random rand = new Random(info.provider.getSeed() + (long)center.chunkX() * 837971201L + (long)center.chunkZ() * 961744153L);
        BlockState glass = info.getCompiledPalette().get(cs.getSphereGlassBlock().charValue(), rand);
        BlockState base = info.getCompiledPalette().get(cs.getSphereBlock().charValue(), rand);
        BlockState side = info.getCompiledPalette().get(cs.getSphereSideBlock().charValue(), rand);
        sphere.setBlocks(glass, base, side);
    }

    public static boolean isInSphere(ChunkCoord coord, BlockPos pos, IDimensionInfo provider) {
        double sqdist;
        CitySphere citySphere;
        boolean sphere = false;
        if ((provider.getProfile().isSpace() || provider.getProfile().isSpheres()) && (citySphere = CitySphere.getCitySphere(coord, provider)).isEnabled() && (sqdist = CitySphere.squaredDistance(citySphere.getCenterPos().getX(), citySphere.getCenterPos().getZ(), pos.getX(), pos.getZ())) <= (double)(citySphere.getRadius() * citySphere.getRadius())) {
            sphere = true;
        }
        return sphere;
    }

    public static float getRelativeDistanceToCityCenter(ChunkCoord coord, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(coord, provider);
        BlockPos centerPos = sphere.getCenterPos();
        float radius = sphere.getRadius();
        int cx = coord.chunkX() * 16 + 8;
        int cz = coord.chunkZ() * 16 + 8;
        int sqdist = (cx - centerPos.getX()) * (cx - centerPos.getX()) + (cz - centerPos.getZ()) * (cz - centerPos.getZ());
        return (float)(Math.sqrt(sqdist) / (double)radius);
    }

    private static boolean hasNonStationMonoRail(ChunkCoord coord, IDimensionInfo provider) {
        if (!CitySphere.fullyInsideCitySpere(coord, provider)) {
            return CitySphere.hasHorizontalMonorail(coord, provider) || CitySphere.hasVerticalMonorail(coord, provider);
        }
        return false;
    }

    public static boolean hasMonorailStation(ChunkCoord coord, IDimensionInfo provider) {
        if (CitySphere.fullyInsideCitySpere(coord, provider)) {
            return CitySphere.hasNonStationMonoRail(coord.west(), provider) || CitySphere.hasNonStationMonoRail(coord.east(), provider) || CitySphere.hasNonStationMonoRail(coord.north(), provider) || CitySphere.hasNonStationMonoRail(coord.south(), provider);
        }
        return false;
    }

    @Override
    public ChunkCoord getCenter() {
        return this.center;
    }

    @Override
    public BlockPos getCenterPos() {
        return this.centerPos;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public void setBlocks(BlockState glassBlock, BlockState baseBlock, BlockState sideBlock) {
        this.glassBlock = glassBlock;
        this.baseBlock = baseBlock;
        this.sideBlock = sideBlock;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public BlockState getGlassBlock() {
        return this.glassBlock;
    }

    public BlockState getBaseBlock() {
        return this.baseBlock;
    }

    public BlockState getSideBlock() {
        return this.sideBlock;
    }

    public static void cleanCache() {
        CITY_SPHERE_CACHE.clear();
    }

    public static boolean hasHorizontalMonorail(ChunkCoord coord, IDimensionInfo provider) {
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        if ((chunkZ & 0xF) == 8) {
            ChunkCoord c;
            CitySphere sphere;
            int cx;
            boolean result = false;
            for (cx = chunkX + 1; cx < chunkX + 64; ++cx) {
                if ((cx & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(c = new ChunkCoord(provider.getType(), cx, chunkZ), provider)).isEnabled()) continue;
                if (!sphere.monorailWestCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
            result = false;
            for (cx = chunkX - 1; cx > chunkX - 64; --cx) {
                if ((cx & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(c = new ChunkCoord(provider.getType(), cx, chunkZ), provider)).isEnabled()) continue;
                if (!sphere.monorailEastCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            return result;
        }
        return false;
    }

    public static boolean hasVerticalMonorail(ChunkCoord coord, IDimensionInfo provider) {
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        if ((chunkX & 0xF) == 8) {
            ChunkCoord c;
            CitySphere sphere;
            int cz;
            boolean result = false;
            for (cz = chunkZ + 1; cz < chunkZ + 64; ++cz) {
                if ((cz & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(c = new ChunkCoord(provider.getType(), chunkX, cz), provider)).isEnabled()) continue;
                if (!sphere.monorailNorthCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
            result = false;
            for (cz = chunkZ - 1; cz > chunkZ - 64; --cz) {
                if ((cz & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(c = new ChunkCoord(provider.getType(), chunkX, cz), provider)).isEnabled()) continue;
                if (!sphere.monorailSouthCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            return result;
        }
        return false;
    }

    private static float getSphereRadius(ChunkCoord center, IDimensionInfo provider, Random rand) {
        PredefinedCity city = City.getPredefinedCity((CommonLevelAccessor)provider.getWorld(), center);
        LostCityProfile profile = provider.getProfile();
        if (city != null) {
            return (float)city.getRadius() * profile.CITYSPHERE_FACTOR;
        }
        return (float)profile.CITY_MINRADIUS + (float)rand.nextInt(profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS) * profile.CITYSPHERE_FACTOR;
    }

    public static boolean fullyInsideCitySpere(ChunkCoord coord, IDimensionInfo provider) {
        int cz;
        CitySphere sphere = CitySphere.getCitySphere(coord, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        double sqradiusOffset = (radius - 2.0f) * (radius - 2.0f);
        int cx = cc.getX();
        if (CitySphere.squaredDistance(cx, cz = cc.getZ(), chunkX * 16, chunkZ * 16) > sqradiusOffset) {
            return false;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) > sqradiusOffset) {
            return false;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) > sqradiusOffset) {
            return false;
        }
        return !(CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) > sqradiusOffset);
    }

    public static boolean intersectsWithCitySphere(ChunkCoord coord, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(coord, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        return CitySphere.intersectChunkWithSphere(coord.chunkX(), coord.chunkZ(), radius, cc);
    }

    private static boolean intersectChunkWithSphere(int chunkX, int chunkZ, float radius, BlockPos cc) {
        int cz;
        double sqradiusOffset = radius * radius;
        int cx = cc.getX();
        if (CitySphere.squaredDistance(cx, cz = cc.getZ(), chunkX * 16, chunkZ * 16) <= sqradiusOffset) {
            return true;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) <= sqradiusOffset) {
            return true;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) <= sqradiusOffset) {
            return true;
        }
        return CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) <= sqradiusOffset;
    }

    public static boolean onCitySphereBorder(ChunkCoord coord, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(coord, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        double sqradiusOffset = radius * radius;
        int cx = cc.getX();
        int cz = cc.getZ();
        int cnt = 0;
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) <= sqradiusOffset) {
            ++cnt;
        }
        return cnt > 0 && cnt < 4;
    }

    public static double squaredDistance(int cx, int cz, int x, int z) {
        return (cx - x) * (cx - x) + (cz - z) * (cz - z);
    }

    private static CitySphere getSphereAtCenter(ChunkCoord center, IDimensionInfo provider, @Nullable PredefinedSphere predef) {
        int chunkX = center.chunkX();
        int chunkZ = center.chunkZ();
        Random rand = new Random(provider.getSeed() + (long)chunkX * 961744153L + (long)chunkZ * 837971201L);
        LostCityProfile profile = provider.getProfile();
        boolean enabled = predef != null || rand.nextFloat() < profile.CITYSPHERE_CHANCE;
        float radius = predef != null ? (float)predef.getRadius() : CitySphere.getSphereRadius(center, provider, rand);
        BlockPos centerPosition = predef != null ? new BlockPos(predef.getCenterX(), profile.GROUNDLEVEL, predef.getCenterZ()) : CitySphere.getSphereCenterPosition(center, provider, rand);
        CitySphere citySphere = new CitySphere(center, radius, centerPosition, enabled);
        if (enabled) {
            citySphere.monorailNorthCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
            citySphere.monorailSouthCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
            citySphere.monorailWestCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
            citySphere.monorailEastCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
        }
        return citySphere;
    }

    public static boolean isCitySphereCenter(ChunkCoord coord, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(coord, provider);
        return sphere.isEnabled() && sphere.getCenter().chunkX() == coord.chunkX() && sphere.getCenter().chunkZ() == coord.chunkZ();
    }

    @Nonnull
    public static synchronized CitySphere getCitySphere(ChunkCoord coord, IDimensionInfo provider) {
        AssetRegistries.loadPredefinedStuff((CommonLevelAccessor)provider.getWorld());
        if (!CITY_SPHERE_CACHE.containsKey(coord)) {
            CitySphere sphere;
            for (PredefinedSphere predef : AssetRegistries.PREDEFINED_SPHERES.getIterable()) {
                if (predef.getDimension() != provider.getType() || !CitySphere.intersectChunkWithSphere(coord.chunkX(), coord.chunkZ(), predef.getRadius(), new BlockPos(predef.getCenterX(), 0, predef.getCenterZ()))) continue;
                ChunkCoord center = new ChunkCoord(provider.getType(), predef.getChunkX(), predef.getChunkZ());
                CitySphere sphere2 = CitySphere.getSphereAtCenter(center, provider, predef);
                CitySphere.updateCache(coord, sphere2);
                return sphere2;
            }
            if (provider.getProfile().CITYSPHERE_ONLY_PREDEFINED) {
                sphere = EMPTY;
            } else {
                int cx = (coord.chunkX() & 0xFFFFFFF0) + 8;
                int cz = (coord.chunkZ() & 0xFFFFFFF0) + 8;
                ChunkCoord center = new ChunkCoord(provider.getType(), cx, cz);
                sphere = CitySphere.getSphereAtCenter(center, provider, null);
            }
            CitySphere.updateCache(coord, sphere);
            return sphere;
        }
        return CITY_SPHERE_CACHE.get(coord);
    }

    private static void updateCache(ChunkCoord coord, CitySphere sphere) {
        CITY_SPHERE_CACHE.put(coord, sphere);
        BlockPos centerPos = sphere.getCenterPos();
        int radius = (int)sphere.getRadius();
        if ((float)radius < 1.0E-4f) {
            CITY_SPHERE_CACHE.put(sphere.center, sphere);
            return;
        }
        for (int cx = centerPos.getX() - radius - 16; cx <= centerPos.getX() + radius + 16; cx += 16) {
            for (int cz = centerPos.getZ() - radius - 16; cz <= centerPos.getZ() + radius + 16; cz += 16) {
                ChunkCoord cc = new ChunkCoord(sphere.getCenter().dimension(), cx >> 4, cz >> 4);
                if (!CitySphere.intersectChunkWithSphere(cc.chunkX(), cc.chunkZ(), radius, centerPos)) continue;
                CITY_SPHERE_CACHE.put(cc, sphere);
            }
        }
    }

    private static BlockPos getSphereCenterPosition(ChunkCoord center, IDimensionInfo provider, Random rand) {
        int cx = (center.chunkX() << 4) + rand.nextInt(16) - 8;
        int cz = (center.chunkZ() << 4) + rand.nextInt(16) - 8;
        return new BlockPos(cx, provider.getProfile().GROUNDLEVEL, cz);
    }
}

