/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import javax.annotation.Nonnull;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Orientation;
import mcjty.lostcities.worldgen.lost.Transform;

public enum Direction {
    XMIN,
    XMAX,
    ZMIN,
    ZMAX;

    public static final Direction[] VALUES;

    public Orientation getOrientation() {
        return this == XMIN || this == XMAX ? Orientation.X : Orientation.Z;
    }

    public Transform getRotation() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Transform.ROTATE_NONE;
            case 1 -> Transform.ROTATE_180;
            case 2 -> Transform.ROTATE_90;
            case 3 -> Transform.ROTATE_270;
        };
    }

    public Direction getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> XMAX;
            case 1 -> XMIN;
            case 2 -> ZMAX;
            case 3 -> ZMIN;
        };
    }

    @Nonnull
    public BuildingInfo get(BuildingInfo info) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> info.getXmin();
            case 1 -> info.getXmax();
            case 2 -> info.getZmin();
            case 3 -> info.getZmax();
        };
    }

    public boolean atSide(int x, int z) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (x == 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (x == 15) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (z == 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> z == 15;
        };
    }

    static {
        VALUES = new Direction[]{XMIN, XMAX, ZMIN, ZMAX};
    }
}

