/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.commands.ModCommands;
import mcjty.lostcities.editor.Editor;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;

public class CommandCreatePart
implements Command<CommandSourceStack> {
    private static final CommandCreatePart CMD = new CommandCreatePart();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"createpart").requires(cs -> cs.m_6761_(1))).then(Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ModCommands.getPartSuggestionProvider()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes((Command)CMD)));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        BuildingPart part = null;
        try {
            part = AssetRegistries.PARTS.get((CommonLevelAccessor)((CommandSourceStack)context.getSource()).m_81372_(), name);
        }
        catch (Exception e) {
            part = null;
        }
        if (part == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error finding part '" + String.valueOf(name) + "'!")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        WorldCoordinates start = (WorldCoordinates)context.getArgument("pos", WorldCoordinates.class);
        ServerLevel level = (ServerLevel)player.m_9236_();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        Editor.startEditing(part, player, start.m_119568_((CommandSourceStack)context.getSource()), level, dimInfo, true);
        return 0;
    }
}

