/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Arrays;
import java.util.OptionalInt;
import mcjty.lostcities.worldgen.NoiseChunkOpt;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;

public class HeightGenOpt {
    public static int getBaseHeight(NoiseBasedChunkGenerator generator, int x, int z, WorldGenLevel level, RandomState rnd) {
        return HeightGenOpt.iterateNoiseColumn((NoiseGeneratorSettings)generator.m_224341_().get(), level, rnd, x, z).orElse(level.m_141937_());
    }

    private static OptionalInt iterateNoiseColumn(NoiseGeneratorSettings noise, WorldGenLevel pLevel, RandomState pRandom, int pX, int pZ) {
        NoiseSettings settings = noise.f_64439_().m_224530_((LevelHeightAccessor)pLevel);
        int cellH = settings.m_189212_();
        int minY = settings.f_158688_();
        int cellMinY = Mth.m_14042_((int)minY, (int)cellH);
        int cellHeight = Mth.m_14042_((int)settings.f_64508_(), (int)cellH);
        if (cellHeight <= 0) {
            return OptionalInt.empty();
        }
        int cellWidth = settings.m_189213_();
        int cellPX = Math.floorDiv(pX, cellWidth);
        int cellPZ = Math.floorDiv(pZ, cellWidth);
        int cellOX = Math.floorMod(pX, cellWidth);
        int cellOZ = Math.floorMod(pZ, cellWidth);
        int cellX = cellPX * cellWidth;
        int cellZ = cellPZ * cellWidth;
        double xFactor = (double)cellOX / (double)cellWidth;
        double zFactor = (double)cellOZ / (double)cellWidth;
        NoiseChunkOpt.FluidStatusV def = new NoiseChunkOpt.FluidStatusV(noise.f_64444_(), noise.f_64441_());
        NoiseChunkOpt chunk = new NoiseChunkOpt(1, pRandom, cellX, cellZ, settings, BeardifierMarker.INSTANCE, noise, def);
        chunk.initializeForFirstCellX();
        chunk.advanceCellX(0);
        for (int y = cellHeight - 1; y >= 0; --y) {
            chunk.selectCellYZ(y, 0);
            for (int y2 = cellH - 1; y2 >= 0; --y2) {
                BlockState state;
                int cellEndBlockY = (cellMinY + y) * cellH + y2;
                double dY = (double)y2 / (double)cellH;
                chunk.updateForYXZ(pX, cellEndBlockY, pZ, xFactor, dY, zFactor);
                BlockState stateI = chunk.getInterpolatedState();
                BlockState blockState = state = stateI == null ? noise.f_64440_() : stateI;
                if (!state.m_280555_()) continue;
                chunk.stopInterpolation();
                return OptionalInt.of(cellEndBlockY + 1);
            }
        }
        chunk.stopInterpolation();
        return OptionalInt.empty();
    }

    protected static enum BeardifierMarker implements DensityFunctions.BeardifierOrMarker
    {
        INSTANCE;


        public double m_207386_(DensityFunction.FunctionContext p_208515_) {
            return 0.0;
        }

        public void m_207362_(double[] p_208517_, DensityFunction.ContextProvider p_208518_) {
            Arrays.fill(p_208517_, 0.0);
        }

        public double m_207402_() {
            return 0.0;
        }

        public double m_207401_() {
            return 0.0;
        }
    }
}

