/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.plantsvszombiesreplanted.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.plantsvszombiesreplanted.PlantsVsZombiesReplantedMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlantsVsZombiesReplantedModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PlantsVsZombiesReplantedMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        PlantsVsZombiesReplantedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PlantsVsZombiesReplantedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Sun_Counter = message.data.Sun_Counter;
                    variables.Money = message.data.Money;
                    variables.GaveSeeds = message.data.GaveSeeds;
                    variables.Imatater_Plant_ID = message.data.Imatater_Plant_ID;
                    variables.Bought_Gatling_Pea = message.data.Bought_Gatling_Pea;
                    variables.Bought_Twin_Sunflower = message.data.Bought_Twin_Sunflower;
                    variables.Bought_Gloom_Shroom = message.data.Bought_Gloom_Shroom;
                    variables.Bought_Gold_Magnet = message.data.Bought_Gold_Magnet;
                    variables.Bought_Spikerock = message.data.Bought_Spikerock;
                    variables.Bought_Winter_Melon = message.data.Bought_Winter_Melon;
                    variables.Bought_Cob_Cannon = message.data.Bought_Cob_Cannon;
                    variables.Bought_Imatater = message.data.Bought_Imatater;
                    variables.Bought_Cattail = message.data.Bought_Cattail;
                    variables.NoteGiven = message.data.NoteGiven;
                    variables.Bought_Pool_Cleaners = message.data.Bought_Pool_Cleaners;
                    variables.Bought_Roof_Cleaners = message.data.Bought_Roof_Cleaners;
                    variables.Bought_Wallnuts = message.data.Bought_Wallnuts;
                    variables.Bought_Mallet = message.data.Bought_Mallet;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Sun_Counter = 50.0;
        public double Money = 0.0;
        public boolean GaveSeeds = false;
        public double Imatater_Plant_ID = 0.0;
        public boolean Bought_Gatling_Pea = false;
        public boolean Bought_Twin_Sunflower = false;
        public boolean Bought_Gloom_Shroom = false;
        public boolean Bought_Gold_Magnet = false;
        public boolean Bought_Spikerock = false;
        public boolean Bought_Winter_Melon = false;
        public boolean Bought_Cob_Cannon = false;
        public boolean Bought_Imatater = false;
        public boolean Bought_Cattail = false;
        public boolean NoteGiven = false;
        public boolean Bought_Pool_Cleaners = false;
        public boolean Bought_Roof_Cleaners = false;
        public boolean Bought_Wallnuts = false;
        public boolean Bought_Mallet = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlantsVsZombiesReplantedMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Sun_Counter", this.Sun_Counter);
            nbt.m_128347_("Money", this.Money);
            nbt.m_128379_("GaveSeeds", this.GaveSeeds);
            nbt.m_128347_("Imatater_Plant_ID", this.Imatater_Plant_ID);
            nbt.m_128379_("Bought_Gatling_Pea", this.Bought_Gatling_Pea);
            nbt.m_128379_("Bought_Twin_Sunflower", this.Bought_Twin_Sunflower);
            nbt.m_128379_("Bought_Gloom_Shroom", this.Bought_Gloom_Shroom);
            nbt.m_128379_("Bought_Gold_Magnet", this.Bought_Gold_Magnet);
            nbt.m_128379_("Bought_Spikerock", this.Bought_Spikerock);
            nbt.m_128379_("Bought_Winter_Melon", this.Bought_Winter_Melon);
            nbt.m_128379_("Bought_Cob_Cannon", this.Bought_Cob_Cannon);
            nbt.m_128379_("Bought_Imatater", this.Bought_Imatater);
            nbt.m_128379_("Bought_Cattail", this.Bought_Cattail);
            nbt.m_128379_("NoteGiven", this.NoteGiven);
            nbt.m_128379_("Bought_Pool_Cleaners", this.Bought_Pool_Cleaners);
            nbt.m_128379_("Bought_Roof_Cleaners", this.Bought_Roof_Cleaners);
            nbt.m_128379_("Bought_Wallnuts", this.Bought_Wallnuts);
            nbt.m_128379_("Bought_Mallet", this.Bought_Mallet);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.Sun_Counter = nbt.m_128459_("Sun_Counter");
            this.Money = nbt.m_128459_("Money");
            this.GaveSeeds = nbt.m_128471_("GaveSeeds");
            this.Imatater_Plant_ID = nbt.m_128459_("Imatater_Plant_ID");
            this.Bought_Gatling_Pea = nbt.m_128471_("Bought_Gatling_Pea");
            this.Bought_Twin_Sunflower = nbt.m_128471_("Bought_Twin_Sunflower");
            this.Bought_Gloom_Shroom = nbt.m_128471_("Bought_Gloom_Shroom");
            this.Bought_Gold_Magnet = nbt.m_128471_("Bought_Gold_Magnet");
            this.Bought_Spikerock = nbt.m_128471_("Bought_Spikerock");
            this.Bought_Winter_Melon = nbt.m_128471_("Bought_Winter_Melon");
            this.Bought_Cob_Cannon = nbt.m_128471_("Bought_Cob_Cannon");
            this.Bought_Imatater = nbt.m_128471_("Bought_Imatater");
            this.Bought_Cattail = nbt.m_128471_("Bought_Cattail");
            this.NoteGiven = nbt.m_128471_("NoteGiven");
            this.Bought_Pool_Cleaners = nbt.m_128471_("Bought_Pool_Cleaners");
            this.Bought_Roof_Cleaners = nbt.m_128471_("Bought_Roof_Cleaners");
            this.Bought_Wallnuts = nbt.m_128471_("Bought_Wallnuts");
            this.Bought_Mallet = nbt.m_128471_("Bought_Mallet");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("plants_vs_zombies_replanted", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "plants_vs_zombies_replanted_mapvars";
        public double Sun_Spawn = 1200.0;
        public boolean Dave_Spawned = false;
        public boolean ZombieComingSoundPlayed = false;
        public boolean ZombieWarning = false;
        public boolean Unlock_Zomboss_Defeat = false;
        public double WaveDifficulty = 0.0;
        public double ZombieTimerSpawner = 0.0;
        public double TimeTillHugeWave = 5000.0;
        public boolean HugeWave = false;
        public boolean StartWave = false;
        public double DaysAdded = 3.0;
        public double SpawnWave = 120.0;
        public boolean HasSellItem = false;
        public boolean FlagKilled = true;
        public double NightsAdded = 7.0;
        public boolean GravesSpawn = false;
        public boolean ZombieWarningNight = false;
        public double GraveTimerSpawner = 0.0;
        public double UnlockedPlants = 0.0;
        public double WaveNumber = 0.0;
        public boolean Generate_Botanist_House = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.Sun_Spawn = nbt.m_128459_("Sun_Spawn");
            this.Dave_Spawned = nbt.m_128471_("Dave_Spawned");
            this.ZombieComingSoundPlayed = nbt.m_128471_("ZombieComingSoundPlayed");
            this.ZombieWarning = nbt.m_128471_("ZombieWarning");
            this.Unlock_Zomboss_Defeat = nbt.m_128471_("Unlock_Zomboss_Defeat");
            this.WaveDifficulty = nbt.m_128459_("WaveDifficulty");
            this.ZombieTimerSpawner = nbt.m_128459_("ZombieTimerSpawner");
            this.TimeTillHugeWave = nbt.m_128459_("TimeTillHugeWave");
            this.HugeWave = nbt.m_128471_("HugeWave");
            this.StartWave = nbt.m_128471_("StartWave");
            this.DaysAdded = nbt.m_128459_("DaysAdded");
            this.SpawnWave = nbt.m_128459_("SpawnWave");
            this.HasSellItem = nbt.m_128471_("HasSellItem");
            this.FlagKilled = nbt.m_128471_("FlagKilled");
            this.NightsAdded = nbt.m_128459_("NightsAdded");
            this.GravesSpawn = nbt.m_128471_("GravesSpawn");
            this.ZombieWarningNight = nbt.m_128471_("ZombieWarningNight");
            this.GraveTimerSpawner = nbt.m_128459_("GraveTimerSpawner");
            this.UnlockedPlants = nbt.m_128459_("UnlockedPlants");
            this.WaveNumber = nbt.m_128459_("WaveNumber");
            this.Generate_Botanist_House = nbt.m_128471_("Generate_Botanist_House");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("Sun_Spawn", this.Sun_Spawn);
            nbt.m_128379_("Dave_Spawned", this.Dave_Spawned);
            nbt.m_128379_("ZombieComingSoundPlayed", this.ZombieComingSoundPlayed);
            nbt.m_128379_("ZombieWarning", this.ZombieWarning);
            nbt.m_128379_("Unlock_Zomboss_Defeat", this.Unlock_Zomboss_Defeat);
            nbt.m_128347_("WaveDifficulty", this.WaveDifficulty);
            nbt.m_128347_("ZombieTimerSpawner", this.ZombieTimerSpawner);
            nbt.m_128347_("TimeTillHugeWave", this.TimeTillHugeWave);
            nbt.m_128379_("HugeWave", this.HugeWave);
            nbt.m_128379_("StartWave", this.StartWave);
            nbt.m_128347_("DaysAdded", this.DaysAdded);
            nbt.m_128347_("SpawnWave", this.SpawnWave);
            nbt.m_128379_("HasSellItem", this.HasSellItem);
            nbt.m_128379_("FlagKilled", this.FlagKilled);
            nbt.m_128347_("NightsAdded", this.NightsAdded);
            nbt.m_128379_("GravesSpawn", this.GravesSpawn);
            nbt.m_128379_("ZombieWarningNight", this.ZombieWarningNight);
            nbt.m_128347_("GraveTimerSpawner", this.GraveTimerSpawner);
            nbt.m_128347_("UnlockedPlants", this.UnlockedPlants);
            nbt.m_128347_("WaveNumber", this.WaveNumber);
            nbt.m_128379_("Generate_Botanist_House", this.Generate_Botanist_House);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                PlantsVsZombiesReplantedMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "plants_vs_zombies_replanted_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                PlantsVsZombiesReplantedMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Sun_Counter = original.Sun_Counter;
            clone.Money = original.Money;
            clone.GaveSeeds = original.GaveSeeds;
            clone.Imatater_Plant_ID = original.Imatater_Plant_ID;
            clone.Bought_Gatling_Pea = original.Bought_Gatling_Pea;
            clone.Bought_Twin_Sunflower = original.Bought_Twin_Sunflower;
            clone.Bought_Gloom_Shroom = original.Bought_Gloom_Shroom;
            clone.Bought_Gold_Magnet = original.Bought_Gold_Magnet;
            clone.Bought_Spikerock = original.Bought_Spikerock;
            clone.Bought_Winter_Melon = original.Bought_Winter_Melon;
            clone.Bought_Cob_Cannon = original.Bought_Cob_Cannon;
            clone.Bought_Imatater = original.Bought_Imatater;
            clone.Bought_Cattail = original.Bought_Cattail;
            clone.NoteGiven = original.NoteGiven;
            clone.Bought_Pool_Cleaners = original.Bought_Pool_Cleaners;
            clone.Bought_Roof_Cleaners = original.Bought_Roof_Cleaners;
            clone.Bought_Wallnuts = original.Bought_Wallnuts;
            clone.Bought_Mallet = original.Bought_Mallet;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    PlantsVsZombiesReplantedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    PlantsVsZombiesReplantedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                PlantsVsZombiesReplantedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

