/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.common.SpaceRegion;
import net.povstalec.stellarview.api.common.space_objects.distinct.Sol;
import net.povstalec.stellarview.client.render.SpaceRegionRenderer;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class SpaceRenderer {
    private static class_310 minecraft = class_310.method_1551();
    private static final Vector3f NULL_VECTOR = new Vector3f();
    private static final int STAR_LIMIT = 100000;
    private static final int DUST_CLOUD_LIMIT = 50000;
    private static final HashMap<SpaceRegion.RegionPos, SpaceRegionRenderer> SPACE_REGIONS = new HashMap();
    public static final Matrix3f IDENTITY_MATRIX;
    public static Matrix3f lensingMatrix;
    public static Matrix3f lensingMatrixInv;
    public static float lensingIntensity;
    @Nullable
    private static Sol sol;
    @Nullable
    private static SpaceCoords solCoords;
    @Nullable
    private static AxisRotation solAxisRotation;
    private static int starsPerTick;
    private static int dustCloudsPerTick;

    public static void updateSpaceObjects() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        SpaceRenderer.updateSol();
        SpaceRenderer.resetStarFields();
    }

    public static boolean loadNewStars() {
        return starsPerTick < 100000;
    }

    public static void loadedStars(int starCount) {
        starsPerTick += starCount;
    }

    public static boolean loadNewDustClouds() {
        return dustCloudsPerTick < 50000;
    }

    public static void loadedDustClouds(int dustCloudCount) {
        dustCloudsPerTick += dustCloudCount;
    }

    public static void clear() {
        sol = null;
        solCoords = null;
        solAxisRotation = null;
        SPACE_REGIONS.clear();
    }

    public static void addSpaceRegion(SpaceRegionRenderer spaceRegion) {
        SPACE_REGIONS.put(spaceRegion.getRegionPos(), spaceRegion);
    }

    public static void removeSpaceRegion(SpaceRegion.RegionPos regionPos) {
        SPACE_REGIONS.remove(regionPos);
    }

    public static void addSpaceObjectRenderer(SpaceObjectRenderer spaceObjectRenderer) {
        SpaceRegionRenderer region = SpaceRenderer.getOrCreateRegion(spaceObjectRenderer.spaceCoords());
        region.addChild(spaceObjectRenderer);
    }

    public static void setupSynodicOrbits() {
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            spaceRegionEntry.getValue().setupSynodicOrbits();
        }
    }

    public static void resetStarFields() {
        starsPerTick = 0;
        dustCloudsPerTick = 0;
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            spaceRegionEntry.getValue().resetStarFields();
            spaceRegionEntry.getValue().resetConstellations();
        }
    }

    public static void render(ViewCenter viewCenter, SpaceObjectRenderer masterParent, class_638 level, class_4184 camera, float partialTicks, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, class_289 tesselator) {
        starsPerTick = 0;
        dustCloudsPerTick = 0;
        SpaceRenderer.setBestLensing();
        SpaceRegion.RegionPos pos = new SpaceRegion.RegionPos(viewCenter.getCoords());
        minecraft.method_16011().method_15396("dustClouds");
        if (viewCenter.dustCloudBrightness() > 0.0f) {
            for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
                if (!spaceRegionEntry.getKey().isInRange(pos, SpaceRenderer.getRange())) continue;
                spaceRegionEntry.getValue().renderDustClouds(viewCenter, level, camera, partialTicks, modelViewMatrix, projectionMatrix, setupFog, viewCenter.dustCloudBrightness());
            }
        }
        minecraft.method_16011().method_15407();
        SpaceRegionRenderer centerRegion = null;
        minecraft.method_16011().method_15396("spaceObjects");
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            if (!spaceRegionEntry.getKey().equals(pos)) {
                if (!spaceRegionEntry.getKey().isInRange(pos, SpaceRenderer.getRange())) continue;
                spaceRegionEntry.getValue().render(viewCenter, masterParent, level, camera, partialTicks, modelViewMatrix, projectionMatrix, isFoggy, setupFog, tesselator);
                continue;
            }
            centerRegion = spaceRegionEntry.getValue();
        }
        if (centerRegion != null) {
            centerRegion.render(viewCenter, masterParent, level, camera, partialTicks, modelViewMatrix, projectionMatrix, isFoggy, setupFog, tesselator);
        }
        masterParent.render(viewCenter, level, partialTicks, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog, tesselator, NULL_VECTOR, new AxisRotation());
        minecraft.method_16011().method_15407();
    }

    private static void setBestLensing() {
        lensingMatrix = IDENTITY_MATRIX;
        lensingMatrixInv = IDENTITY_MATRIX;
        lensingIntensity = 0.0f;
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            spaceRegionEntry.getValue().setBestLensing();
        }
    }

    public static void addSol(Sol solStar) {
        if (sol != null) {
            StellarView.LOGGER.error("Could not set Sol as a distinct Space Object because it has already been set");
            return;
        }
        StellarView.LOGGER.debug("Setting Sol as a distinct Space Object");
        sol = solStar;
        solCoords = solStar.getCoords().copy();
        solAxisRotation = solStar.getAxisRotation().copy();
        SpaceRenderer.updateSol();
    }

    public static void updateSol() {
        if (sol == null) {
            return;
        }
        if (OverworldConfig.config_priority.get()) {
            SpaceCoords coords = solCoords.copy().add(OverworldConfig.sol_x_offset.get() * 1000, OverworldConfig.sol_y_offset.get() * 1000, OverworldConfig.sol_z_offset.get() * 1000);
            AxisRotation axisRotation = solAxisRotation.copy().add(new AxisRotation(OverworldConfig.sol_x_rotation.get(), OverworldConfig.sol_y_rotation.get(), OverworldConfig.sol_z_rotation.get()));
            sol.setPosAndRotation(coords, axisRotation);
        } else {
            sol.setPosAndRotation(solCoords.copy(), solAxisRotation.copy());
        }
    }

    public static int getRange() {
        return GeneralConfig.space_region_render_distance.get();
    }

    @Nullable
    public static SpaceRegionRenderer getRegion(SpaceRegion.RegionPos pos) {
        if (SPACE_REGIONS.containsKey(pos)) {
            return SPACE_REGIONS.get(pos);
        }
        return null;
    }

    @Nullable
    public static SpaceRegionRenderer getRegion(SpaceCoords coords) {
        return SpaceRenderer.getRegion(new SpaceRegion.RegionPos(coords));
    }

    public static SpaceRegionRenderer getOrCreateRegion(SpaceRegion.RegionPos pos) {
        return SPACE_REGIONS.computeIfAbsent(pos, position -> new SpaceRegionRenderer(new SpaceRegion(pos)));
    }

    public static SpaceRegionRenderer getOrCreateRegion(SpaceCoords coords) {
        return SpaceRenderer.getOrCreateRegion(new SpaceRegion.RegionPos(coords));
    }

    static {
        lensingMatrix = IDENTITY_MATRIX = new Matrix3f();
        lensingMatrixInv = IDENTITY_MATRIX;
        lensingIntensity = 0.0f;
        sol = null;
        solCoords = null;
        solAxisRotation = null;
        starsPerTick = 0;
        dustCloudsPerTick = 0;
    }
}

