/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.shader.CelestialShaderInstance;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class CelestialBuffer
implements AutoCloseable {
    private int vertexBufferId;
    private int indexBufferId;
    private int arrayObjectId;
    @Nullable
    private class_293 format;
    @Nullable
    private RenderSystem.class_5590 sequentialIndices;
    private class_293.class_5595 indexType;
    private int indexCount;
    private class_293.class_5596 mode;

    public CelestialBuffer() {
        RenderSystem.assertOnRenderThread();
        this.vertexBufferId = GlStateManager._glGenBuffers();
        this.indexBufferId = GlStateManager._glGenBuffers();
        this.arrayObjectId = GlStateManager._glGenVertexArrays();
    }

    public void upload(class_287.class_7433 buffer) {
        if (!this.isInvalid()) {
            RenderSystem.assertOnRenderThread();
            try {
                class_287.class_4574 bufferbuilder$drawstate = buffer.method_43583();
                this.format = this.uploadVertexBuffer(bufferbuilder$drawstate, buffer.method_43581());
                this.sequentialIndices = this.uploadIndexBuffer(bufferbuilder$drawstate, buffer.method_43582());
                this.indexCount = bufferbuilder$drawstate.comp_751();
                this.indexType = bufferbuilder$drawstate.comp_753();
                this.mode = bufferbuilder$drawstate.comp_752();
            }
            finally {
                buffer.method_43585();
            }
        }
    }

    private class_293 uploadVertexBuffer(class_287.class_4574 drawState, ByteBuffer vertexBuffer) {
        boolean formatEquals = false;
        if (!drawState.comp_749().equals((Object)this.format)) {
            if (this.format != null) {
                this.format.method_22651();
            }
            GlStateManager._glBindBuffer((int)34962, (int)this.vertexBufferId);
            drawState.comp_749().method_22649();
            formatEquals = true;
        }
        if (!drawState.comp_754()) {
            if (!formatEquals) {
                GlStateManager._glBindBuffer((int)34962, (int)this.vertexBufferId);
            }
            RenderSystem.glBufferData((int)34962, (ByteBuffer)vertexBuffer, (int)35044);
        }
        return drawState.comp_749();
    }

    @Nullable
    private RenderSystem.class_5590 uploadIndexBuffer(class_287.class_4574 drawState, ByteBuffer indexBuffer) {
        if (!drawState.comp_755()) {
            GlStateManager._glBindBuffer((int)34963, (int)this.indexBufferId);
            RenderSystem.glBufferData((int)34963, (ByteBuffer)indexBuffer, (int)35044);
            return null;
        }
        RenderSystem.class_5590 rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer((class_293.class_5596)drawState.comp_752());
        if (rendersystem$autostorageindexbuffer != this.sequentialIndices || !rendersystem$autostorageindexbuffer.method_43409(drawState.comp_751())) {
            rendersystem$autostorageindexbuffer.method_43410(drawState.comp_751());
        }
        return rendersystem$autostorageindexbuffer;
    }

    public void bind() {
        class_286.method_43436();
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
    }

    public static void unbind() {
        class_286.method_43436();
        GlStateManager._glBindVertexArray((int)0);
    }

    public void draw() {
        RenderSystem.drawElements((int)this.mode.field_27383, (int)this.indexCount, (int)this.getIndexType().field_27374);
    }

    private class_293.class_5595 getIndexType() {
        RenderSystem.class_5590 rendersystem$autostorageindexbuffer = this.sequentialIndices;
        return rendersystem$autostorageindexbuffer != null ? rendersystem$autostorageindexbuffer.method_31924() : this.indexType;
    }

    public void drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, class_5944 shaderInstance) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._drawWithShader(new Matrix4f((Matrix4fc)modelViewMatrix), new Matrix4f((Matrix4fc)projectionMatrix), shaderInstance));
        } else {
            this._drawWithShader(modelViewMatrix, projectionMatrix, shaderInstance);
        }
    }

    public void drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, SpaceCoords relativeSpacePos, CelestialShaderInstance shaderInstance) {
        Vector3f relativeVectorLy = new Vector3f((float)relativeSpacePos.x().ly(), (float)relativeSpacePos.y().ly(), (float)relativeSpacePos.z().ly());
        Vector3f relativeVectorKm = new Vector3f((float)relativeSpacePos.x().km(), (float)relativeSpacePos.y().km(), (float)relativeSpacePos.z().km());
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._drawWithShader(new Matrix4f((Matrix4fc)modelViewMatrix), new Matrix4f((Matrix4fc)projectionMatrix), relativeVectorLy, relativeVectorKm, shaderInstance));
        } else {
            this._drawWithShader(modelViewMatrix, projectionMatrix, relativeVectorLy, relativeVectorKm, shaderInstance);
        }
    }

    private void _drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, class_5944 shaderInstance) {
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            shaderInstance.method_34583("Sampler" + i, (Object)j);
        }
        if (shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(modelViewMatrix);
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(projectionMatrix);
        }
        if (shaderInstance.field_36323 != null) {
            shaderInstance.field_36323.method_39978(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.field_29477 != null) {
            shaderInstance.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shaderInstance.field_29478 != null) {
            shaderInstance.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shaderInstance.field_29479 != null) {
            shaderInstance.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shaderInstance.field_36373 != null) {
            shaderInstance.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (shaderInstance.field_29472 != null) {
            shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderInstance.field_29481 != null) {
            shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shaderInstance.field_29473 != null) {
            class_1041 window = class_310.method_1551().method_22683();
            shaderInstance.field_29473.method_1255((float)window.method_4489(), (float)window.method_4506());
        }
        if (shaderInstance.field_29480 != null && (this.mode == class_293.class_5596.field_27377 || this.mode == class_293.class_5596.field_27378)) {
            shaderInstance.field_29480.method_1251(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
        this.draw();
        shaderInstance.method_34585();
    }

    private void _drawWithShader(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Vector3f relativeSpaceLy, Vector3f relativeSpaceKm, CelestialShaderInstance shaderInstance) {
        if (shaderInstance.RELATIVE_SPACE_LY != null) {
            shaderInstance.RELATIVE_SPACE_LY.method_34413(relativeSpaceLy);
        }
        if (shaderInstance.RELATIVE_SPACE_KM != null) {
            shaderInstance.RELATIVE_SPACE_KM.method_34413(relativeSpaceKm);
        }
        if (shaderInstance.LENSING_MAT != null) {
            shaderInstance.LENSING_MAT.method_39978(SpaceRenderer.lensingMatrix);
        }
        if (shaderInstance.LENSING_MAT_INV != null) {
            shaderInstance.LENSING_MAT_INV.method_39978(SpaceRenderer.lensingMatrixInv);
        }
        if (shaderInstance.LENSING_INTENSITY != null) {
            shaderInstance.LENSING_INTENSITY.method_1251(SpaceRenderer.lensingIntensity);
        }
        this._drawWithShader(modelViewMatrix, projectionMatrix, shaderInstance);
    }

    @Override
    public void close() {
        if (this.vertexBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.vertexBufferId);
            this.vertexBufferId = -1;
        }
        if (this.indexBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.indexBufferId);
            this.indexBufferId = -1;
        }
        if (this.arrayObjectId >= 0) {
            RenderSystem.glDeleteVertexArrays((int)this.arrayObjectId);
            this.arrayObjectId = -1;
        }
    }

    public class_293 getFormat() {
        return this.format;
    }

    public boolean isInvalid() {
        return this.arrayObjectId == -1;
    }
}

