/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class StellarViewSkyEffects {
    public static VertexBuffer createDarkSky() {
        VertexBuffer darkBuffer = new VertexBuffer();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = StellarViewSkyEffects.buildSkyDisc(bufferbuilder, -16.0f);
        darkBuffer.m_85921_();
        darkBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
        return darkBuffer;
    }

    public static VertexBuffer createLightSky() {
        VertexBuffer skyBuffer = new VertexBuffer();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = StellarViewSkyEffects.buildSkyDisc(bufferbuilder, 16.0f);
        skyBuffer.m_85921_();
        skyBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
        return skyBuffer;
    }

    public static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float scale) {
        float baseRadius = 512.0f;
        float invertibleBaseRadius = Math.signum(scale) * baseRadius;
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        builder.m_5483_(0.0, (double)scale, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            float radians = (float)Math.toRadians(i);
            builder.m_5483_((double)(invertibleBaseRadius * Mth.m_14089_((float)radians)), (double)scale, (double)(baseRadius * Mth.m_14031_((float)radians))).m_5752_();
        }
        return builder.m_231175_();
    }

    public static void renderSunrise(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, BufferBuilder bufferbuilder) {
        float[] sunriseColor = level.m_104583_().m_7518_(level.m_46942_(partialTicks), partialTicks);
        if (sunriseColor != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.m_85836_();
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float sunAngle = Mth.m_14031_((float)level.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            stack.m_252781_(Axis.f_252403_.m_252977_(sunAngle));
            stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float sunriseR = sunriseColor[0];
            float sunriseG = sunriseColor[1];
            float sunriseB = sunriseColor[2];
            float sunriseA = sunriseColor[2];
            Matrix4f sunriseMatrix = stack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(sunriseMatrix, 0.0f, 100.0f, 0.0f).m_85950_(sunriseR, sunriseG, sunriseB, sunriseA).m_5752_();
            for (int i = 0; i <= 16; ++i) {
                float rotation = (float)i * ((float)Math.PI * 2) / 16.0f;
                float x = Mth.m_14031_((float)rotation);
                float y = Mth.m_14089_((float)rotation);
                bufferbuilder.m_252986_(sunriseMatrix, x * 120.0f, y * 120.0f, -y * 40.0f * sunriseA).m_85950_(sunriseR, sunriseG, sunriseB, 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            stack.m_85849_();
        }
    }

    public static void renderSky(Minecraft minecraft, VertexBuffer skyBuffer, ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, ShaderInstance shaderinstance) {
        skyBuffer.m_85921_();
        skyBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
    }

    public static void renderDark(Minecraft minecraft, VertexBuffer darkBuffer, ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, ShaderInstance shaderinstance, Vec3 skyColor) {
        float skyX = (float)skyColor.f_82479_;
        float skyY = (float)skyColor.f_82480_;
        float skyZ = (float)skyColor.f_82481_;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double height = minecraft.f_91074_.m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (height < 0.0) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 12.0f, 0.0f);
            darkBuffer.m_85921_();
            darkBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            stack.m_85849_();
        }
        if (level.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(skyX * 0.2f + 0.04f), (float)(skyY * 0.2f + 0.04f), (float)(skyZ * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        }
    }
}

