/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OrbitingObject
extends TexturedObject {
    public static final String ORBIT_INFO = "orbit_info";
    public static final Vector3f INITIAL_ORBIT_VECTOR = new Vector3f(-1.0f, 0.0f, 0.0f);
    @Nullable
    private OrbitInfo orbitInfo;
    public static final Codec<OrbitingObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)OrbitInfo.CODEC.optionalFieldOf(ORBIT_INFO).forGetter(object -> Optional.ofNullable(object.orbitInfo)), (App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(TexturedObject::getTextureLayers), (App)TexturedObject.FadeOutHandler.CODEC.optionalFieldOf("fade_out_handler", (Object)TexturedObject.FadeOutHandler.DEFAULT_PLANET_HANDLER).forGetter(TexturedObject::getFadeOutHandler)).apply((Applicative)instance, OrbitingObject::new));

    public OrbitingObject() {
    }

    public OrbitingObject(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler) {
        super(parent, coords, axisRotation, textureLayers, fadeOutHandler);
        if (orbitInfo.isPresent()) {
            this.orbitInfo = orbitInfo.get();
        }
    }

    @Nullable
    public OrbitInfo orbitInfo() {
        return this.orbitInfo;
    }

    public void setupSynodicOrbit(@Nullable OrbitalPeriod parentOrbitalPeriod) {
        if (this.orbitInfo() != null) {
            this.orbitInfo().orbitalPeriod().updateFromParentPeriod(parentOrbitalPeriod);
            this.orbitInfo().setupSweep();
            for (SpaceObject child : this.children) {
                if (!(child instanceof OrbitingObject)) continue;
                OrbitingObject orbitingObject = (OrbitingObject)child;
                orbitingObject.setupSynodicOrbit(this.orbitInfo().orbitalPeriod());
            }
        } else {
            for (SpaceObject child : this.children) {
                if (!(child instanceof OrbitingObject)) continue;
                OrbitingObject orbitingObject = (OrbitingObject)child;
                orbitingObject.setupSynodicOrbit(null);
            }
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.orbitInfo != null) {
            tag.m_128365_(ORBIT_INFO, (Tag)this.orbitInfo.serializeNBT());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128441_(ORBIT_INFO)) {
            this.orbitInfo = new OrbitInfo();
            this.orbitInfo.deserializeNBT(tag.m_128469_(ORBIT_INFO));
        } else {
            this.orbitInfo = null;
        }
    }

    public static class OrbitInfo
    implements INBTSerializable<CompoundTag> {
        public static final String APOAPSIS = "apoapsis";
        public static final String PERIAPSIS = "periapsis";
        public static final String ORBIT_CLAMP_DISTANCE = "orbit_clamp_distance";
        public static final String ORBITAL_PERIOD = "orbital_period";
        public static final String ARGUMENT_OF_PERIAPSIS = "argument_of_periapsis";
        public static final String INCLINATION = "inclination";
        public static final String LONGITUDE_OF_ASCENDING_NODE = "longitude_of_ascending_node";
        public static final String EPOCH_MEAN_ANOMALY = "epoch_mean_anomaly";
        public static final Codec<OrbitInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)1.0f, (float)Float.MAX_VALUE).fieldOf(APOAPSIS).forGetter(OrbitInfo::apoapsis), (App)Codec.floatRange((float)1.0f, (float)Float.MAX_VALUE).fieldOf(PERIAPSIS).forGetter(OrbitInfo::periapsis), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf(ORBIT_CLAMP_DISTANCE, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::orbitClampNumber), (App)OrbitalPeriod.CODEC.fieldOf(ORBITAL_PERIOD).forGetter(OrbitInfo::orbitalPeriod), (App)Codec.FLOAT.optionalFieldOf(ARGUMENT_OF_PERIAPSIS, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::argumentOfPeriapsis), (App)Codec.FLOAT.optionalFieldOf(INCLINATION, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::inclination), (App)Codec.FLOAT.optionalFieldOf(LONGITUDE_OF_ASCENDING_NODE, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::longtitudeOfAscendingNode), (App)Codec.FLOAT.optionalFieldOf(EPOCH_MEAN_ANOMALY, (Object)Float.valueOf(0.0f)).forGetter(OrbitInfo::epochMeanAnomaly)).apply((Applicative)instance, OrbitInfo::new));
        private float apoapsis;
        private float periapsis;
        private float orbitClampDistance;
        private OrbitalPeriod orbitalPeriod;
        private float argumentOfPeriapsis;
        private float inclination;
        private float longitudeOfAscendingNode;
        private float epochMeanAnomaly;
        private float sweep;
        private float eccentricity;
        private Matrix4f orbitMatrix;

        public OrbitInfo() {
        }

        public OrbitInfo(float apoapsis, float periapsis, float orbitClampDistance, OrbitalPeriod orbitalPeriod, float argumentOfPeriapsis, float inclination, float longitudeOfAscendingNode, float meanAnomaly) {
            this.apoapsis = apoapsis;
            this.periapsis = periapsis;
            this.orbitClampDistance = orbitClampDistance;
            this.orbitalPeriod = orbitalPeriod;
            this.argumentOfPeriapsis = (float)Math.toRadians(argumentOfPeriapsis);
            this.inclination = (float)Math.toRadians(inclination);
            this.longitudeOfAscendingNode = (float)Math.toRadians(longitudeOfAscendingNode);
            this.epochMeanAnomaly = (float)Math.toRadians(meanAnomaly);
            this.setupSweep();
            this.eccentricity = (apoapsis - periapsis) / (apoapsis + periapsis);
            this.orbitMatrix = this.orbitMatrix();
        }

        public float apoapsis() {
            return this.apoapsis;
        }

        public float periapsis() {
            return this.periapsis;
        }

        public float orbitClampNumber() {
            return this.orbitClampDistance;
        }

        public void setupSweep() {
            this.sweep = (float)(Math.PI * 2 * this.orbitalPeriod().frequency());
        }

        public OrbitalPeriod orbitalPeriod() {
            return this.orbitalPeriod;
        }

        public float argumentOfPeriapsis() {
            return this.argumentOfPeriapsis;
        }

        public float inclination() {
            return this.inclination;
        }

        public float longtitudeOfAscendingNode() {
            return this.longitudeOfAscendingNode;
        }

        public float epochMeanAnomaly() {
            return this.epochMeanAnomaly;
        }

        public float eccentricity() {
            return this.eccentricity;
        }

        public Vector3f getOrbitVector(long ticks, float partialTicks) {
            Vector3f orbitVector = new Vector3f((Vector3fc)INITIAL_ORBIT_VECTOR);
            float trueAnomaly = (float)this.eccentricAnomaly(ticks, partialTicks);
            orbitVector.mulProject((Matrix4fc)this.movementMatrix(trueAnomaly));
            orbitVector.mulProject((Matrix4fc)this.getOrbitMatrix());
            return orbitVector;
        }

        public Vector3f getOrbitVector(long ticks, float partialTicks, double distance) {
            if (this.orbitClampDistance > 0.0f && distance > (double)this.orbitClampDistance) {
                float mul = (float)distance / this.orbitClampDistance;
                return this.getOrbitVector(ticks, partialTicks).mulProject((Matrix4fc)new Matrix4f().scale(mul, mul, mul));
            }
            return this.getOrbitVector(ticks, partialTicks);
        }

        public double meanAnomaly(long ticks, float partialTicks) {
            return this.epochMeanAnomaly + this.sweep * ((float)(ticks - (long)GeneralConfig.tick_multiplier.get()) + partialTicks);
        }

        public double eccentricAnomaly(long ticks, float partialTicks) {
            return OrbitInfo.approximateEccentricAnomaly(this.eccentricity, this.meanAnomaly(ticks % this.orbitalPeriod().ticks(), partialTicks), 4);
        }

        public Matrix4f movementMatrix(float orbitProgress) {
            return new Matrix4f().rotate((Quaternionfc)Axis.f_252436_.m_252961_(orbitProgress));
        }

        public Matrix4f orbitMatrix() {
            float semiMajorAxis = (this.apoapsis + this.periapsis) / 2.0f;
            Matrix4f scaleMatrix = new Matrix4f().scale(semiMajorAxis, semiMajorAxis, semiMajorAxis);
            Matrix4f eccentricityMatrix = new Matrix4f().scale(1.0f, 1.0f, 1.0f - this.eccentricity());
            Matrix4f offsetMatrix = new Matrix4f().translate((Vector3fc)new Vector3f(semiMajorAxis - this.periapsis, 0.0f, 0.0f));
            Matrix4f periapsisMatrix = new Matrix4f().rotate((Quaternionfc)Axis.f_252436_.m_252961_(this.argumentOfPeriapsis));
            Matrix4f inclinationMatrix = new Matrix4f().rotate((Quaternionfc)Axis.f_252403_.m_252961_(this.inclination));
            Matrix4f ascensionMatrix = new Matrix4f().rotate((Quaternionfc)Axis.f_252436_.m_252961_(this.longitudeOfAscendingNode));
            return ascensionMatrix.mul((Matrix4fc)inclinationMatrix).mul((Matrix4fc)periapsisMatrix).mul((Matrix4fc)offsetMatrix).mul((Matrix4fc)eccentricityMatrix).mul((Matrix4fc)scaleMatrix);
        }

        public Matrix4f getOrbitMatrix() {
            return this.orbitMatrix;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_(APOAPSIS, this.apoapsis);
            tag.m_128350_(PERIAPSIS, this.periapsis);
            tag.m_128350_(ORBIT_CLAMP_DISTANCE, this.orbitClampDistance);
            tag.m_128365_(ORBITAL_PERIOD, (Tag)this.orbitalPeriod.serializeNBT());
            tag.m_128350_(ARGUMENT_OF_PERIAPSIS, this.argumentOfPeriapsis);
            tag.m_128350_(INCLINATION, this.inclination);
            tag.m_128350_(LONGITUDE_OF_ASCENDING_NODE, this.longitudeOfAscendingNode);
            tag.m_128350_(EPOCH_MEAN_ANOMALY, this.epochMeanAnomaly);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.apoapsis = tag.m_128457_(APOAPSIS);
            this.periapsis = tag.m_128457_(PERIAPSIS);
            this.orbitClampDistance = tag.m_128457_(ORBIT_CLAMP_DISTANCE);
            this.orbitalPeriod = new OrbitalPeriod();
            this.orbitalPeriod.deserializeNBT(tag.m_128469_(ORBITAL_PERIOD));
            this.argumentOfPeriapsis = tag.m_128457_(ARGUMENT_OF_PERIAPSIS);
            this.inclination = tag.m_128457_(INCLINATION);
            this.longitudeOfAscendingNode = tag.m_128457_(LONGITUDE_OF_ASCENDING_NODE);
            this.epochMeanAnomaly = tag.m_128457_(EPOCH_MEAN_ANOMALY);
            this.setupSweep();
            this.eccentricity = (this.apoapsis - this.periapsis) / (this.apoapsis + this.periapsis);
            this.orbitMatrix = this.orbitMatrix();
        }

        public static double approximateEccentricAnomaly(double eccentricity, double meanAnomaly, int iterations) {
            double sinMeanAnomaly = Math.sin(meanAnomaly);
            double E = meanAnomaly + eccentricity * (sinMeanAnomaly / (1.0 - Math.sin(meanAnomaly + eccentricity) + sinMeanAnomaly));
            for (int i = 0; i < iterations; ++i) {
                E -= (E - eccentricity * Math.sin(E) - meanAnomaly) / (1.0 - eccentricity * Math.cos(E));
            }
            return E;
        }
    }

    public static class OrbitalPeriod
    implements INBTSerializable<CompoundTag> {
        public static final String TICKS = "ticks";
        public static final String ORBITS = "orbits";
        public static final String SYNODIC = "synodic";
        private long ticks;
        private double orbits;
        private boolean synodic;
        private double frequency;
        public static final Codec<OrbitalPeriod> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf(TICKS).forGetter(OrbitalPeriod::ticks), (App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).optionalFieldOf(ORBITS, (Object)1.0).forGetter(OrbitalPeriod::orbits), (App)Codec.BOOL.optionalFieldOf(SYNODIC, (Object)false).forGetter(OrbitalPeriod::synodic)).apply((Applicative)instance, OrbitalPeriod::new));

        public OrbitalPeriod() {
        }

        public OrbitalPeriod(long ticks, double orbits, boolean synodic) {
            if (ticks <= 0L) {
                throw new IllegalArgumentException("Value ticks outside of range [1:2147483647]");
            }
            this.ticks = ticks;
            this.orbits = orbits;
            this.synodic = synodic;
            this.frequency = orbits / (double)ticks;
        }

        public void updateFromParentPeriod(OrbitalPeriod parentPeriod) {
            if (!this.synodic || parentPeriod == null) {
                return;
            }
            this.ticks = parentPeriod.ticks;
            this.orbits = this.frequency * (double)this.ticks + 1.0;
            this.frequency = this.orbits / (double)this.ticks;
            this.synodic = false;
        }

        public long ticks() {
            return this.ticks;
        }

        public double orbits() {
            return this.orbits;
        }

        public boolean synodic() {
            return this.synodic;
        }

        public double frequency() {
            return this.frequency;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_(TICKS, this.ticks);
            tag.m_128347_(ORBITS, this.orbits);
            tag.m_128379_(SYNODIC, this.synodic);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.ticks = tag.m_128454_(TICKS);
            this.orbits = tag.m_128459_(ORBITS);
            this.synodic = tag.m_128471_(SYNODIC);
            this.frequency = this.orbits / (double)this.ticks;
        }
    }
}

