/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.client.render.ViewCenters;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.compatibility.enhancedcelestials.EnhancedCelestialsCompatibility;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StellarViewOverworldEffects
extends DimensionSpecialEffects.OverworldEffects {
    public static final ResourceLocation OVERWORLD_EFFECTS = new ResourceLocation("overworld");
    public static final float TWILIGHT_START = 0.4f;
    protected final float[] f_108858_ = new float[4];

    @Nullable
    public float[] m_7518_(float timeOfDay, float partialTicks) {
        float sunXProjection = Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2)));
        if (sunXProjection >= -0.4f && sunXProjection <= 0.4f) {
            float sunProjectionA = sunXProjection / 0.4f * 0.5f + 0.5f;
            float sunProjectionB = 1.0f - (1.0f - Mth.m_14031_((float)(sunProjectionA * (float)Math.PI))) * 0.99f;
            sunProjectionB *= sunProjectionB;
            this.f_108858_[0] = sunProjectionA * 0.3f + 0.7f;
            this.f_108858_[1] = sunProjectionA * sunProjectionA * 0.7f + 0.2f;
            this.f_108858_[2] = sunProjectionA * sunProjectionA * 0.0f + 0.2f;
            this.f_108858_[3] = sunProjectionB;
            return this.f_108858_;
        }
        return null;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (OverworldConfig.replace_vanilla.get()) {
            return ViewCenters.renderViewCenterSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        return false;
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (OverworldConfig.replace_vanilla.get() && StellarView.isEnhancedCelestialsLoaded()) {
            EnhancedCelestialsCompatibility.adjustLightmapColors(level, partialTicks, skyDarken, skyLight, blockLight, pixelX, pixelY, colors);
        }
    }
}

