/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;

public abstract class SpaceObjectRenderer<RenderedObject extends SpaceObject> {
    protected SpaceObjectRenderer parent;
    protected RenderedObject renderedObject;
    protected double lastDistance = 0.0;
    protected ArrayList<SpaceObjectRenderer<?>> children;

    public SpaceObjectRenderer(RenderedObject renderedObject) {
        this.renderedObject = renderedObject;
        this.children = new ArrayList();
    }

    public SpaceCoords spaceCoords() {
        return ((SpaceObject)this.renderedObject).getCoords();
    }

    public AxisRotation axisRotation() {
        return ((SpaceObject)this.renderedObject).getAxisRotation();
    }

    public Vector3f getPosition(ViewCenter viewCenter, AxisRotation axisRotation, long ticks, float partialTicks) {
        return new Vector3f();
    }

    public Vector3f getPosition(ViewCenter viewCenter, long ticks, float partialTicks) {
        return new Vector3f();
    }

    public void addParent(SpaceObjectRenderer<?> parent) {
        this.parent = parent;
    }

    public void addChildRaw(SpaceObjectRenderer<?> child) {
        if (child.parent != null) {
            StellarView.LOGGER.error(this.toString() + " already has a parent");
            return;
        }
        this.children.add(child);
        child.addParent(this);
        ((SpaceObject)this.renderedObject).addChildRaw((SpaceObject)child.renderedObject);
    }

    public void addChild(SpaceObjectRenderer<?> child) {
        if (child.parent != null) {
            StellarView.LOGGER.error(this.toString() + " already has a parent");
            return;
        }
        this.children.add(child);
        child.addParent(this);
        ((SpaceObject)this.renderedObject).addChild((SpaceObject)child.renderedObject);
    }

    public ArrayList<SpaceObjectRenderer<?>> children() {
        return this.children;
    }

    public RenderedObject renderedObject() {
        return this.renderedObject;
    }

    public void setupSpaceObject(ResourceLocation id) {
        if (id != null) {
            ((SpaceObject)this.renderedObject()).setResourceLocation(id);
        }
    }

    public String toString() {
        return ((SpaceObject)this.renderedObject).toString();
    }

    public abstract void render(ViewCenter var1, ClientLevel var2, float var3, PoseStack var4, Camera var5, Matrix4f var6, boolean var7, Runnable var8, BufferBuilder var9, Vector3f var10, AxisRotation var11);

    public void renderFrom(ViewCenter viewCenter, ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, BufferBuilder bufferbuilder) {
        if (this.parent != null) {
            viewCenter.addCoords(this.getPosition(viewCenter, this.parent.axisRotation(), viewCenter.ticks(), partialTicks));
        } else {
            viewCenter.addCoords(this.getPosition(viewCenter, viewCenter.ticks(), partialTicks));
        }
        if (this.parent != null) {
            this.parent.renderFrom(viewCenter, level, partialTicks, stack, camera, projectionMatrix, isFoggy, setupFog, bufferbuilder);
        } else {
            viewCenter.renderSkyObjects(this, level, partialTicks, stack, camera, projectionMatrix, isFoggy, setupFog, bufferbuilder);
        }
    }
}

