/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mrbysco.flatterentities.FlatConfig;
import com.mrbysco.flatterentities.Flattener;
import com.mrbysco.flatterentities.Keybinds;
import com.mrbysco.flatterentities.Reference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="flatterentities")
public class FlatterEntities {
    public FlatterEntities(IEventBus eventBus, ModContainer container, Dist dist) {
        if (dist.isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)FlatConfig.clientSpec);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.register(FlatConfig.class);
            eventBus.addListener(Keybinds::registerKeybinds);
            NeoForge.EVENT_BUS.register((Object)new Keybinds());
        }
    }

    public static void reloadCache() {
        ResourceLocation resourceLocation;
        Flattener.entityBlacklist.clear();
        for (String value : (List)FlatConfig.CLIENT.entityBlacklist.get()) {
            if (value.isEmpty()) continue;
            resourceLocation = ResourceLocation.tryParse((String)value);
            if (resourceLocation != null) {
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(resourceLocation);
                if (entityType != null) {
                    Flattener.entityBlacklist.add(entityType);
                    continue;
                }
                Reference.LOGGER.error("Invalid entity blacklist value: {}, Unable to locate entity", (Object)value);
                continue;
            }
            Reference.LOGGER.error("Invalid entity blacklist value: {}, Are you sure this is the resource location of the entity?", (Object)value);
        }
        Flattener.entityDimensionWhitelist.clear();
        for (String value : (List)FlatConfig.CLIENT.entityDimensionWhitelist.get()) {
            String[] splitValue;
            if (!value.contains(",") || (splitValue = value.split(",")).length != 2) continue;
            ResourceLocation entityLocation = ResourceLocation.tryParse((String)splitValue[0]);
            ResourceLocation worldLocation = ResourceLocation.tryParse((String)splitValue[1]);
            if (entityLocation == null || worldLocation == null) continue;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(entityLocation);
            if (entityType != null) {
                ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)worldLocation);
                List entityList = Flattener.entityDimensionWhitelist.getOrDefault(worldKey, new ArrayList());
                entityList.add(entityType);
                Flattener.entityDimensionWhitelist.put((ResourceKey<Level>)worldKey, entityList);
                continue;
            }
            Reference.LOGGER.error("Invalid entity dimension whitelist value: {}, Unable to locate entity", (Object)value);
        }
        Flattener.dimensionListIsWhitelist = (Boolean)FlatConfig.CLIENT.invertDimensionBlacklist.get();
        Flattener.dimensionBlacklist.clear();
        for (String value : (List)FlatConfig.CLIENT.dimensionBlacklist.get()) {
            if (value.isEmpty()) continue;
            resourceLocation = ResourceLocation.tryParse((String)value);
            if (resourceLocation != null) {
                ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)resourceLocation);
                Flattener.dimensionBlacklist.add((ResourceKey<Level>)worldKey);
                continue;
            }
            Reference.LOGGER.error("Invalid dimension blacklist value: {}, Are you sure this is the resource location of the dimension?", (Object)value);
        }
    }
}

