/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mrbysco.flatterentities.FlatterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5498;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class Flattener {
    public static boolean renderingEnabled = true;
    public static final List<class_1299<?>> entityBlacklist = new ArrayList();
    public static final Map<class_5321<class_1937>, List<class_1299<?>>> entityDimensionWhitelist = new HashMap();
    public static final List<class_5321<class_1937>> dimensionBlacklist = new ArrayList<class_5321<class_1937>>();
    public static boolean dimensionListIsWhitelist = false;

    public static void prepareFlatRendering(float rotation, double x, double z, class_4587 poseStack, class_10017 renderState) {
        if (renderingEnabled && renderState instanceof FlatterInfo) {
            FlatterInfo info = (FlatterInfo)renderState;
            class_1299<?> entityType = info.flatterentities$getEntityType();
            class_5321<class_1937> entityDimension = info.flatterentities$getDimension();
            boolean isPlayer = renderState instanceof class_10055;
            boolean entityInList = entityBlacklist.contains(entityType);
            boolean worldInList = dimensionBlacklist.contains(entityDimension);
            boolean entityBlacklisted = !entityBlacklist.isEmpty() && entityInList;
            boolean dimensionFlat = dimensionBlacklist.isEmpty() || !dimensionBlacklist.isEmpty() && dimensionListIsWhitelist == worldInList;
            boolean renderAnyway = false;
            if (!dimensionBlacklist.isEmpty() && !entityDimensionWhitelist.isEmpty()) {
                List whitelist = entityDimensionWhitelist.getOrDefault(entityDimension, new ArrayList());
                boolean bl = renderAnyway = whitelist.contains(entityType) && !entityBlacklisted;
            }
            if (!entityBlacklisted && (dimensionFlat || renderAnyway)) {
                class_5498 viewPoint = class_310.method_1551().field_1690.method_31044();
                float offset = 0.0f;
                double angle1 = class_3532.method_15338((double)(Math.atan2(z, x) / Math.PI * 180.0));
                double angle2 = class_3532.method_15338((double)(Math.floor(((double)rotation - angle1) / 45.0) * 45.0));
                if (isPlayer) {
                    offset = ((class_10055)renderState).field_53447;
                }
                if (isPlayer) {
                    if (viewPoint == class_5498.field_26664 || viewPoint == class_5498.field_26665) {
                        angle1 = -90.0f - offset;
                    }
                    if (viewPoint == class_5498.field_26666) {
                        angle1 = 90.0f + offset;
                    }
                }
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)angle1));
                poseStack.method_22905(0.02f, 1.0f, 1.0f);
                if (isPlayer) {
                    if (viewPoint == class_5498.field_26664 || viewPoint == class_5498.field_26665) {
                        angle2 = 90.0f + offset;
                    }
                    if (viewPoint == class_5498.field_26666) {
                        angle2 = -90.0f - offset;
                    }
                }
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)angle2));
            }
        }
    }

    public static <T extends class_1309> float getYawRotation(T entityIn, float partialTicks, boolean shouldSit) {
        class_1297 class_12972;
        float lerpedBody = class_3532.method_17821((float)partialTicks, (float)entityIn.field_6220, (float)entityIn.field_6283);
        float lerpedHead = class_3532.method_17821((float)partialTicks, (float)entityIn.field_6259, (float)entityIn.field_6241);
        if (shouldSit && (class_12972 = entityIn.method_5854()) instanceof class_1309) {
            class_1309 livingentity = (class_1309)class_12972;
            lerpedBody = class_3532.method_17821((float)partialTicks, (float)livingentity.field_6220, (float)livingentity.field_6283);
            float f2 = lerpedHead - lerpedBody;
            float degrees = class_3532.method_15393((float)f2);
            if (degrees < -85.0f) {
                degrees = -85.0f;
            }
            if (degrees >= 85.0f) {
                degrees = 85.0f;
            }
            lerpedBody = lerpedHead - degrees;
            if (degrees * degrees > 2500.0f) {
                lerpedBody += degrees * 0.2f;
            }
        }
        return lerpedBody;
    }
}

