/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import ru.imaginaerum.wd.Config;
import ru.imaginaerum.wd.client.ClientProxy;
import ru.imaginaerum.wd.common.armor.elytra.DragoliteElytraArmorStandLayer;
import ru.imaginaerum.wd.common.armor.elytra.DragoliteElytraLayer;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.entity.ModBlockEntities;
import ru.imaginaerum.wd.common.custom_recipes.ProperBrewingRecipe;
import ru.imaginaerum.wd.common.effects.EffectsWD;
import ru.imaginaerum.wd.common.entities.ModEntities;
import ru.imaginaerum.wd.common.items.ItemsWD;
import ru.imaginaerum.wd.common.items.armor.model_layered.WDModelLayers;
import ru.imaginaerum.wd.common.items.arrows.DispenserRegistry;
import ru.imaginaerum.wd.common.items.arrows.EntityTypeInit;
import ru.imaginaerum.wd.common.items.arrows.FlameArrowRenderer;
import ru.imaginaerum.wd.common.items.custom.IronWateringCan;
import ru.imaginaerum.wd.common.items.entity.ModEntitiesItem;
import ru.imaginaerum.wd.common.items.entity.client.ModBoatRenderer;
import ru.imaginaerum.wd.common.particles.ModParticles;
import ru.imaginaerum.wd.common.sounds.CustomSoundEvents;
import ru.imaginaerum.wd.common.tab.TabWD;
import ru.imaginaerum.wd.server.CommonProxy;

@Mod(value="wd")
public class WD {
    public static CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final String MODID = "wd";
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public WD() {
        PROXY.commonInit();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(this::registerElytraLayer);
        }
        modEventBus.addListener(this::registerLayerDefinitions);
        EntityTypeInit.ENTITY_TYPES.register(modEventBus);
        ItemsWD.ITEMS.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        BlocksWD.BLOCKS.register(modEventBus);
        ModEntities.ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CustomSoundEvents.SOUND_EVENTS.register(modEventBus);
        EffectsWD.MOB_EFFECTS.register(modEventBus);
        ModEntitiesItem.ENTITIES.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        TabWD.CREATIVE_MODE_TABS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            if (e.getTabKey() == TabWD.WD_TAB.getKey()) {
                // empty if block
            }
        });
    }

    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        WDModelLayers.register(event);
    }

    public static ItemStack createPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
    }

    public static ItemStack createSplashPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion);
    }

    public static ItemStack createLingeringPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion);
    }

    public static ItemStack createItemStack(Item item) {
        return new ItemStack((ItemLike)item);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createPotion(Potions.f_43599_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.WARPED_WART.get()}), WD.createPotion(Potions.f_43602_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createSplashPotion(Potions.f_43599_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.WARPED_WART.get()}), WD.createSplashPotion(Potions.f_43602_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createLingeringPotion(Potions.f_43599_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.WARPED_WART.get()}), WD.createLingeringPotion(Potions.f_43602_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.SUGAR_REFINED.get()}), WD.createPotion(Potions.f_43614_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createSplashPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.SUGAR_REFINED.get()}), WD.createSplashPotion(Potions.f_43614_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createLingeringPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.SUGAR_REFINED.get()}), WD.createLingeringPotion(Potions.f_43614_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createPotion(Potions.f_43601_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.HANDFUL_NETHER.get()}), WD.createPotion(Potions.f_43592_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createSplashPotion(Potions.f_43601_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.HANDFUL_NETHER.get()}), WD.createSplashPotion(Potions.f_43592_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createLingeringPotion(Potions.f_43601_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.HANDFUL_NETHER.get()}), WD.createLingeringPotion(Potions.f_43592_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createPotion(Potions.f_43601_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.BRIGHT_PEPPER.get()}), WD.createPotion(Potions.f_43611_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createSplashPotion(Potions.f_43601_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.BRIGHT_PEPPER.get()}), WD.createSplashPotion(Potions.f_43611_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createLingeringPotion(Potions.f_43601_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.BRIGHT_PEPPER.get()}), WD.createLingeringPotion(Potions.f_43611_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.POISON_BERRY.get()}), WD.createPotion(Potions.f_43586_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createSplashPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.POISON_BERRY.get()}), WD.createSplashPotion(Potions.f_43586_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createLingeringPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.POISON_BERRY.get()}), WD.createLingeringPotion(Potions.f_43586_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WD.createItemStack(Items.f_42590_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsWD.COASTAL_STEEP_FLOWER.get()}), WD.createPotion(Potions.f_43599_)));
        });
        DispenserRegistry.registerBehaviors();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerElytraLayer(EntityRenderersEvent event) {
        if (event instanceof EntityRenderersEvent.AddLayers) {
            EntityRenderersEvent.AddLayers addLayersEvent = (EntityRenderersEvent.AddLayers)event;
            EntityModelSet entityModels = addLayersEvent.getEntityModels();
            addLayersEvent.getSkins().forEach(s -> {
                LivingEntityRenderer livingEntityRenderer = addLayersEvent.getSkin(s);
                if (livingEntityRenderer instanceof PlayerRenderer) {
                    PlayerRenderer playerRenderer = (PlayerRenderer)livingEntityRenderer;
                    playerRenderer.m_115326_((RenderLayer)new DragoliteElytraLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer, entityModels));
                }
            });
            LivingEntityRenderer livingEntityRenderer = addLayersEvent.getRenderer(EntityType.f_20529_);
            if (livingEntityRenderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer armorStandRenderer = (ArmorStandRenderer)livingEntityRenderer;
                armorStandRenderer.m_115326_((RenderLayer)new DragoliteElytraArmorStandLayer(armorStandRenderer, entityModels));
            }
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @Mod.EventBusSubscriber(modid="wd", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> PROXY.clientInit());
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityTypeInit.FLAME_ARROW.get()), FlameArrowRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntitiesItem.MOD_BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntitiesItem.MOD_CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            event.enqueueWork(() -> {
                ItemProperties.register((Item)((Item)ItemsWD.IRON_WATERING_CAN.get()), (ResourceLocation)new ResourceLocation(WD.MODID, "water_full"), (stack, level, entity, seed) -> IronWateringCan.isFull(stack) ? 1.0f : 0.0f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.FIRE_STEM.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.WARPED_WART.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.POISON_BERRY.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.MEADOW_GOLDEN_FLOWER.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.ROSE_OF_GHOSTY_TEARS.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.ROSE_OF_THE_MURDERER.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.MEDICAL_POTATO.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.SPATIAL_ORCHID.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.APPLE_LEAVES.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.APPLE_LEAVES_STAGES.get()), 0.2f);
                ComposterBlock.f_51914_.put((Object)((ItemLike)ItemsWD.APPLE_SAPLING.get()), 0.2f);
            });
        }
    }
}

