/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.AABB;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.custom.EchotronBlock;
import ru.imaginaerum.wd.common.blocks.custom.MagicCompost;
import ru.imaginaerum.wd.common.blocks.entity.ModBlockEntities;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class EchotronBlockEntity
extends BlockEntity
implements GameEventListener.Holder<VibrationSystem.Listener>,
VibrationSystem,
GeoAnimatable {
    private VibrationSystem.Data vibrationData;
    private final VibrationSystem.Listener vibrationListener;
    private final VibrationSystem.User vibrationUser;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public EchotronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ECHOTRON_ENTITY.get(), pos, state);
        this.vibrationUser = new EchotronUser(pos);
        this.vibrationData = new VibrationSystem.Data();
        this.vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return 0.0;
    }

    protected class EchotronUser
    implements VibrationSystem.User {
        private final BlockPos blockPos;
        private final PositionSource positionSource;

        public EchotronUser(BlockPos pos) {
            this.blockPos = pos;
            this.positionSource = new BlockPositionSource(pos);
        }

        public int m_280351_() {
            return 8;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, @Nullable GameEvent.Context context) {
            return true;
        }

        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent event, @Nullable Entity entity, @Nullable Entity source, float distance) {
            BlockState state = EchotronBlockEntity.this.m_58900_();
            int stage = (Integer)state.m_61143_((Property)EchotronBlock.STAGE);
            if (stage < 29) {
                level.m_7731_(EchotronBlockEntity.this.m_58899_(), (BlockState)state.m_61124_((Property)EchotronBlock.STAGE, (Comparable)Integer.valueOf(stage + 1)), 3);
                ++stage;
            }
            if (stage == 29) {
                float damageAmount = 10.0f;
                BlockState blockState = EchotronBlockEntity.this.m_58900_();
                Direction direction = (Direction)blockState.m_61143_((Property)EchotronBlock.FACING);
                DamageSource damageSource = level.m_269111_().m_269285_(null);
                BlockPos blockPos = EchotronBlockEntity.this.m_58899_();
                AABB area = this.createForwardCone(blockPos, direction, 15.0f, 30.0f);
                List entities = level.m_45976_(LivingEntity.class, area);
                for (LivingEntity target : entities) {
                    if (target.m_20147_() || !target.m_5801_()) continue;
                    target.m_6469_(damageSource, damageAmount);
                    double dX = target.m_20185_() - (double)blockPos.m_123341_();
                    double dZ = target.m_20189_() - (double)blockPos.m_123343_();
                    target.m_147240_(1.0, dX, dZ);
                }
                if (level.m_46462_() && !level.m_46471_()) {
                    for (BlockPos posInArea : BlockPos.m_121976_((int)((int)area.f_82288_), (int)((int)area.f_82289_), (int)((int)area.f_82290_), (int)((int)area.f_82291_), (int)((int)area.f_82292_), (int)((int)area.f_82293_))) {
                        BlockState newState;
                        int currentStage;
                        BlockState checkState = level.m_8055_(posInArea);
                        if (checkState.m_60734_() instanceof MagicCompost) {
                            currentStage = MagicCompost.getStage(checkState);
                            if (!MagicCompost.isMaxStage(checkState)) {
                                newState = MagicCompost.setStage(checkState, currentStage + 1);
                                level.m_7731_(posInArea, newState, 3);
                                level.m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)posInArea.m_123341_() + 0.5, (double)posInArea.m_123342_() + 0.5, (double)posInArea.m_123343_() + 0.5, 8, 0.3, 0.3, 0.3, 0.05);
                            }
                        }
                        if (!(checkState.m_60734_() instanceof MagicCompost)) continue;
                        currentStage = MagicCompost.getStage(checkState);
                        if (currentStage >= 3) {
                            level.m_7731_(posInArea, ((Block)BlocksWD.MAGIC_SOIL.get()).m_49966_(), 3);
                            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)posInArea.m_123341_() + 0.5, (double)posInArea.m_123342_() + 0.5, (double)posInArea.m_123343_() + 0.5, 10, 0.4, 0.4, 0.4, 0.05);
                            continue;
                        }
                        newState = MagicCompost.setStage(checkState, currentStage + 1);
                        level.m_7731_(posInArea, newState, 3);
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)posInArea.m_123341_() + 0.5, (double)posInArea.m_123342_() + 0.5, (double)posInArea.m_123343_() + 0.5, 8, 0.3, 0.3, 0.3, 0.05);
                    }
                }
                level.m_7731_(EchotronBlockEntity.this.m_58899_(), (BlockState)state.m_61124_((Property)EchotronBlock.STAGE, (Comparable)Integer.valueOf(0)), 3);
                level.m_5594_(null, EchotronBlockEntity.this.m_58899_(), SoundEvents.f_215771_, SoundSource.HOSTILE, 3.0f, 1.0f);
                this.spawnDirectionalParticles(level, blockPos, direction);
                return;
            }
            float pitch = 0.5f + (float)stage / 29.0f;
            level.m_5594_(null, pos, SoundEvents.f_144212_, SoundSource.BLOCKS, 1.0f, pitch);
        }

        private AABB createForwardCone(BlockPos blockPos, Direction direction, float length, float angleDegrees) {
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.5;
            double z = (double)blockPos.m_123343_() + 0.5;
            double forwardX = x + (double)((float)direction.m_122429_() * length / 2.0f);
            double forwardY = y + (double)((float)direction.m_122430_() * length / 2.0f);
            double forwardZ = z + (double)((float)direction.m_122431_() * length / 2.0f);
            double radius = (double)length * Math.tan(Math.toRadians(angleDegrees / 2.0f));
            return new AABB(forwardX - radius, forwardY - radius, forwardZ - radius, forwardX + radius, forwardY + radius, forwardZ + radius);
        }

        private void spawnDirectionalParticles(ServerLevel level, BlockPos blockPos, Direction direction) {
            double startX = (double)blockPos.m_123341_() + 0.5;
            double startY = (double)blockPos.m_123342_() + 1.0;
            double startZ = (double)blockPos.m_123343_() + 0.5;
            double length = 15.0;
            for (double distance = 1.0; distance <= length; distance += 0.5) {
                double particleX = startX + (double)direction.m_122429_() * distance;
                double particleY = startY + (double)direction.m_122430_() * distance;
                double particleZ = startZ + (double)direction.m_122431_() * distance;
                double spread = 0.3;
                double offsetX = level.f_46441_.m_188583_() * spread;
                double offsetY = level.f_46441_.m_188583_() * spread;
                double offsetZ = level.f_46441_.m_188583_() * spread;
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 0, 0.0, 0.0, 0.0, 0.1);
            }
            for (int i = 0; i < 10; ++i) {
                double distance = length * (0.2 + 0.8 * level.f_46441_.m_188500_());
                double particleX = startX + (double)direction.m_122429_() * distance;
                double particleY = startY + (double)direction.m_122430_() * distance;
                double particleZ = startZ + (double)direction.m_122431_() * distance;
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, particleX, particleY, particleZ, 1, level.f_46441_.m_188583_() * 0.1, level.f_46441_.m_188583_() * 0.1, level.f_46441_.m_188583_() * 0.1, 0.05);
            }
        }

        public void m_280022_() {
            EchotronBlockEntity.this.m_6596_();
        }

        public boolean m_280215_() {
            return true;
        }
    }
}

