/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.mixin;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.imaginaerum.wd.common.items.ItemsWD;

@Mixin(value={Hoglin.class})
public class HoglinMixin
extends Animal
implements Enemy,
HoglinBase {
    @Unique
    private static final EntityDataAccessor<Boolean> PREVENT_ZOMBIFICATION = SynchedEntityData.m_135353_(Hoglin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected HoglinMixin(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void onDefineSynchedData(CallbackInfo info) {
        ((Hoglin)this).m_20088_().m_135372_(PREVENT_ZOMBIFICATION, (Object)false);
    }

    public boolean isPreventZombification() {
        return (Boolean)((Hoglin)this).m_20088_().m_135370_(PREVENT_ZOMBIFICATION);
    }

    public void setPreventZombification(boolean preventZombification) {
        ((Hoglin)this).m_20088_().m_135381_(PREVENT_ZOMBIFICATION, (Object)preventZombification);
    }

    @Inject(method={"isImmuneToZombification()Z"}, at={@At(value="RETURN")}, cancellable=true)
    protected void isImmuneToZombification(CallbackInfoReturnable<Boolean> cir) {
        if (this.isPreventZombification()) {
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21205_().m_41720_() == ItemsWD.NETHER_GROG.get() && !this.isPreventZombification()) {
            Random random = new Random();
            if ((double)random.nextFloat() < 0.7) {
                this.setPreventZombification(true);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 1.0, 1.0, 1.0, 0.1);
                }
                this.m_5496_(SoundEvents.f_11956_, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            this.m_5496_(SoundEvents.f_12593_, 1.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                Level level;
                Zoglin zombifiedPiglin = (Zoglin)EntityType.f_20500_.m_20615_(this.m_9236_());
                zombifiedPiglin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                if (this.m_6162_()) {
                    zombifiedPiglin.m_6863_(true);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, zombifiedPiglin.m_20185_(), zombifiedPiglin.m_20186_() + 1.0, zombifiedPiglin.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                zombifiedPiglin.m_20331_(this.m_20147_());
                this.m_146870_();
                this.m_9236_().m_7967_((Entity)zombifiedPiglin);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_20223_(CompoundTag tag) {
        tag.m_128379_("PreventZombification", this.isPreventZombification());
        return super.m_20223_(tag);
    }

    public void m_20258_(CompoundTag tag) {
        super.m_20258_(tag);
        if (tag.m_128441_("PreventZombification")) {
            this.setPreventZombification(tag.m_128471_("PreventZombification"));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public int m_7575_() {
        return 0;
    }
}

