/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1320;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class BonusDataStore {
    private static final List<BonusEntry> currentBonuses = new ArrayList<BonusEntry>();
    private static final Set<class_2960> EXCLUDED_ATTRIBUTES = Set.of(class_2960.method_60655((String)"spell_engine", (String)"damage_taken"));

    public static void loadFromNbt(class_2487 nbt) {
        currentBonuses.clear();
        for (String key : nbt.method_10541()) {
            class_2960 id = class_2960.method_12829((String)key);
            if (id == null || EXCLUDED_ATTRIBUTES.contains(id)) continue;
            class_2487 attrData = nbt.method_10562(key);
            double base = attrData.method_10574("Base");
            double finalVal = attrData.method_10574("Final");
            if (Double.isNaN(finalVal) || Math.abs(finalVal - base) < 1.0E-4) continue;
            ArrayList<String> flatSources = new ArrayList<String>();
            if (attrData.method_10545("Flat")) {
                for (Object element : attrData.method_10554("Flat", 10)) {
                    class_2487 flat = (class_2487)element;
                    String source = flat.method_10558("Source");
                    double val = flat.method_10574("Value");
                    flatSources.add(String.format("%s: %+,.2f", source, val));
                }
            }
            ArrayList<String> baseMultSources = new ArrayList<String>();
            if (attrData.method_10545("BaseMult")) {
                Object element;
                element = attrData.method_10554("BaseMult", 10).iterator();
                while (element.hasNext()) {
                    class_2520 element2 = (class_2520)element.next();
                    class_2487 mod = (class_2487)element2;
                    String source = mod.method_10558("Source");
                    double val = mod.method_10574("Value");
                    baseMultSources.add(String.format("%s: %+d%% Base", source, (int)(val * 100.0)));
                }
            }
            ArrayList<String> totalMultSources = new ArrayList<String>();
            if (attrData.method_10545("TotalMult")) {
                for (class_2520 element : attrData.method_10554("TotalMult", 10)) {
                    class_2487 mod = (class_2487)element;
                    String source = mod.method_10558("Source");
                    double val = mod.method_10574("Value");
                    totalMultSources.add(String.format("%s: %+d%% Total", source, (int)(val * 100.0)));
                }
            }
            currentBonuses.add(new BonusEntry(class_2960.method_12829((String)key), base, finalVal, flatSources, baseMultSources, totalMultSources));
        }
        currentBonuses.sort(Comparator.comparing(e -> e.attributeId.toString()));
    }

    public static List<BonusEntry> getBonuses() {
        return currentBonuses;
    }

    public static Map<class_2561, Double> getCondensedBonusesFrom(class_2487 nbt) {
        ArrayList<BonusEntry> bonuses = new ArrayList<BonusEntry>();
        Set<class_2960> excluded = EXCLUDED_ATTRIBUTES;
        for (String key : nbt.method_10541()) {
            class_2960 id = class_2960.method_12829((String)key);
            if (id == null || excluded.contains(id)) continue;
            class_2487 attrData = nbt.method_10562(key);
            double base = attrData.method_10574("Base");
            double finalVal = attrData.method_10574("Final");
            if (Double.isNaN(finalVal) || Math.abs(finalVal - base) < 0.001) continue;
            double delta = finalVal - base;
            class_5250 label = class_7923.field_41190.method_10250(id) ? class_2561.method_43471((String)((class_1320)class_7923.field_41190.method_10223(id)).method_26830()) : class_2561.method_43470((String)BonusDataStore.formatName(id.method_12832()));
            boolean merged = false;
            for (BonusEntry existingKey : bonuses) {
                if (!existingKey.attributeId.equals((Object)id)) continue;
                merged = true;
                break;
            }
            if (merged) continue;
            bonuses.add(new BonusEntry(id, base, finalVal, List.of(), List.of(), List.of()));
        }
        LinkedHashMap<class_2561, Double> condensed = new LinkedHashMap<class_2561, Double>();
        for (BonusEntry entry : bonuses) {
            class_2960 id = entry.attributeId();
            double delta = entry.finalValue() - entry.base();
            class_5250 label = class_7923.field_41190.method_10250(id) ? class_2561.method_43471((String)((class_1320)class_7923.field_41190.method_10223(id)).method_26830()) : class_2561.method_43470((String)BonusDataStore.formatName(id.method_12832()));
            boolean merged = false;
            for (class_2561 key : condensed.keySet()) {
                if (!key.getString().equals(label.getString())) continue;
                condensed.put(key, (Double)condensed.get(key) + delta);
                merged = true;
                break;
            }
            if (merged) continue;
            condensed.put((class_2561)label, delta);
        }
        return condensed;
    }

    private static String formatName(String path) {
        CharSequence[] words = path.split("_");
        for (int i = 0; i < words.length; ++i) {
            if (words[i].length() <= 0) continue;
            words[i] = Character.toUpperCase(((String)words[i]).charAt(0)) + ((String)words[i]).substring(1);
        }
        return String.join((CharSequence)" ", words);
    }

    public record BonusEntry(class_2960 attributeId, double base, double finalValue, List<String> flatSources, List<String> baseMultSources, List<String> totalMultSources) {
    }
}

