/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.pixeldreamstudios.showmeyourbuild.client.gui.BuildViewScreen;

@Environment(value=EnvType.CLIENT)
public class AccessorySlotRenderer {
    public static final class_2960 BACKGROUND_TEXTURE_OVERFLOW = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/gui/gui2.png");
    private static final int SLOT_SIZE = 16;
    private static final int SLOT_PADDING = 4;
    private static final int MAX_VISIBLE = 20;
    private static boolean overflowExpanded = false;
    private static int overflowX = 0;
    private static int overflowY = 0;
    private static int overflowButtonX = 0;
    private static int overflowButtonY = 0;
    private static List<class_1799> overflowStacks = new ArrayList<class_1799>();
    public static boolean debug_message = false;

    public static void render(class_332 context, class_1657 entity, List<class_1799> snapshotAccessories, int centerX, int centerY, class_327 textRenderer, int mouseX, int mouseY) {
        int i;
        ArrayList<class_3545> equipped = new ArrayList<class_3545>();
        if (snapshotAccessories != null && !snapshotAccessories.isEmpty()) {
            for (class_1799 stack : snapshotAccessories) {
                equipped.add(new class_3545(null, (Object)stack));
            }
        } else {
            TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(component -> equipped.addAll(component.getAllEquipped()));
        }
        if (equipped.isEmpty()) {
            return;
        }
        int visibleCount = Math.min(equipped.size(), 20);
        int hiddenCount = equipped.size() - 20;
        int slotsPerRow = 10;
        int spacing = 20;
        int totalRows = (int)Math.ceil((float)visibleCount / 10.0f);
        int totalHeight = totalRows * 20;
        int yStart = centerY - totalHeight / 2;
        overflowX = 0;
        overflowY = -10;
        for (i = 0; i < visibleCount; ++i) {
            int row = i / 10;
            int col = i % 10;
            int rowSize = Math.min(10, visibleCount - row * 10);
            int rowStartX = centerX - rowSize * 20 / 2;
            int x = rowStartX + col * 20;
            int y = yStart + row * 20;
            if (i == visibleCount - 1) {
                overflowX = x + 20;
                overflowY = y;
            }
            AccessorySlotRenderer.renderSlot(context, textRenderer, (class_3545<SlotReference, class_1799>)((class_3545)equipped.get(i)), x, y, mouseX, mouseY);
        }
        if (hiddenCount > 0) {
            overflowStacks.clear();
            for (i = 20; i < equipped.size(); ++i) {
                overflowStacks.add((class_1799)((class_3545)equipped.get(i)).method_15441());
            }
            int x = overflowX;
            int y = overflowY - 10;
            overflowButtonX = x;
            overflowButtonY = y;
            boolean hovered = mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16;
            int bgColor = hovered ? -12566464 : -1442840576;
            context.method_25294(x, y, x + 16, y + 16, bgColor);
            String moreText = "+" + hiddenCount;
            int textX = x + (16 - textRenderer.method_1727(moreText)) / 2;
            int textY = y + 4;
            context.method_25303(textRenderer, moreText, textX, textY, 0xFFFFFF);
            if (hovered && !overflowExpanded) {
                context.method_51438(textRenderer, (class_2561)class_2561.method_43470((String)"Click to show more"), mouseX, mouseY);
            }
            if (overflowExpanded) {
                AccessorySlotRenderer.drawOverflowPanel(context, textRenderer, mouseX, mouseY);
            }
        }
    }

    private static void drawOverflowPanel(class_332 context, class_327 textRenderer, int mouseX, int mouseY) {
        int slotSize = 16;
        int padding = 4;
        int columns = 5;
        int rows = (int)Math.ceil((float)overflowStacks.size() / 5.0f);
        int panelWidth = 104;
        int panelHeight = rows * 20 + 4;
        int panelX = overflowX + 16 + 4;
        int panelY = overflowY;
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        if (panelX + panelWidth > screenWidth) {
            panelX = screenWidth - panelWidth - 4;
        }
        if (panelY + panelHeight > screenHeight) {
            panelY = screenHeight - panelHeight - 4;
        }
        if (panelX < 0) {
            panelX = 4;
        }
        if (panelY < 0) {
            panelY = 4;
        }
        class_310.method_1551().method_1531().method_22813(BACKGROUND_TEXTURE_OVERFLOW);
        context.method_25290(BACKGROUND_TEXTURE_OVERFLOW, panelX - 2, panelY - 2, 0.0f, 0.0f, panelWidth + 4, panelHeight + 4, panelWidth + 4, panelHeight + 4);
        for (int i = 0; i < overflowStacks.size(); ++i) {
            int row = i / 5;
            int col = i % 5;
            int x = panelX + 4 + col * 20;
            int y = panelY + 4 + row * 20;
            class_1799 stack = overflowStacks.get(i);
            context.method_51427(stack, x, y);
            context.method_51431(textRenderer, stack, x, y);
            if (mouseX < x || mouseX >= x + 16 || mouseY < y || mouseY >= y + 16) continue;
            context.method_51446(textRenderer, stack, mouseX, mouseY);
        }
    }

    public static boolean mouseClicked(int mouseX, int mouseY) {
        if (mouseX >= overflowButtonX && mouseX < overflowButtonX + 16 && mouseY >= overflowButtonY && mouseY < overflowButtonY + 16) {
            overflowExpanded = !overflowExpanded;
            return true;
        }
        if (overflowExpanded) {
            boolean inside;
            int slotSize = 16;
            int padding = 4;
            int columns = 5;
            int rows = (int)Math.ceil((float)overflowStacks.size() / 5.0f);
            int panelWidth = 104;
            int panelHeight = rows * 20 + 4;
            int panelX = overflowX + 16 + 4;
            int panelY = overflowY;
            boolean bl = inside = mouseX >= panelX && mouseX < panelX + panelWidth && mouseY >= panelY && mouseY < panelY + panelHeight;
            if (!inside) {
                overflowExpanded = false;
            }
        }
        return false;
    }

    private static void renderSlot(class_332 context, class_327 textRenderer, class_3545<SlotReference, class_1799> pair, int x, int y, int mouseX, int mouseY) {
        class_1799 stack = (class_1799)pair.method_15441();
        context.method_25290(BuildViewScreen.SLOT_BACKGROUND_ACCESSORY, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        context.method_51427(stack, x, y);
        context.method_51431(textRenderer, stack, x, y);
        if (mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16) {
            context.method_51446(textRenderer, stack, mouseX, mouseY);
        }
    }
}

