/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_745;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class PlayerSnapshot {
    public static SnapshotData fromNbt(class_2487 data, String displayName, class_1657 fallbackPlayer) {
        int i;
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        UUID uuid = client.method_31320().method_31407(displayName);
        GameProfile profile = uuid != null ? new GameProfile(uuid, displayName) : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + displayName).getBytes()), displayName);
        class_1799[] armorStacks = new class_1799[4];
        class_1799 mainHand = class_1799.field_8037;
        class_1799 offHand = class_1799.field_8037;
        class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)client.method_1562().method_29091());
        class_2499 armorList = data.method_10554("Armor", 10);
        for (i = 0; i < 4; ++i) {
            armorStacks[i] = class_1799.field_8037;
        }
        for (i = 0; i < armorList.size(); ++i) {
            class_2487 itemNbt = armorList.method_10602(i);
            class_1799 stack = class_1799.field_24671.parse((DynamicOps)ops, (Object)itemNbt).result().orElse(class_1799.field_8037);
            if (stack.method_7960()) continue;
            int slot = -1;
            if (itemNbt.method_10573("Slot", 1)) {
                slot = itemNbt.method_10571("Slot");
            } else {
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1738) {
                    class_1738 armorItem = (class_1738)class_17922;
                    class_1304 detectedSlot = armorItem.method_7685();
                    switch (detectedSlot) {
                        case field_6169: {
                            slot = 3;
                            break;
                        }
                        case field_6174: {
                            slot = 2;
                            break;
                        }
                        case field_6172: {
                            slot = 1;
                            break;
                        }
                        case field_6166: {
                            slot = 0;
                        }
                    }
                }
            }
            if (slot < 0 || slot >= 4) continue;
            armorStacks[slot] = stack;
        }
        if (data.method_10573("MainHand", 10)) {
            mainHand = class_1799.field_24671.parse((DynamicOps)ops, (Object)data.method_10580("MainHand")).result().orElse(class_1799.field_8037);
        }
        if (data.method_10573("OffHand", 10)) {
            offHand = class_1799.field_24671.parse((DynamicOps)ops, (Object)data.method_10580("OffHand")).result().orElse(class_1799.field_8037);
        }
        class_745 fakePlayer = new class_745(world, profile){

            public boolean method_7348(class_1664 part) {
                return true;
            }

            public boolean method_5733() {
                return false;
            }

            public class_2561 method_5477() {
                return class_2561.method_43473();
            }
        };
        fakePlayer.method_5719((class_1297)fallbackPlayer);
        fakePlayer.method_18380(fallbackPlayer.method_18376());
        boolean trinketsLoaded = FabricLoader.getInstance().isModLoaded("trinkets");
        ArrayList<class_1799> accessories = new ArrayList<class_1799>();
        if (data.method_10573("PotionEffects", 9)) {
            class_2499 potionList = data.method_10554("PotionEffects", 10);
            for (int i2 = 0; i2 < potionList.size(); ++i2) {
                class_2487 tag = potionList.method_10602(i2);
                class_2960 id = class_2960.method_12829((String)tag.method_10558("Id"));
                if (id == null || !class_7923.field_41174.method_10250(id)) continue;
                class_5321 key = class_5321.method_29179((class_5321)class_7923.field_41174.method_30517(), (class_2960)id);
                fakePlayer.method_6092(new class_1293((class_6880)class_7923.field_41174.method_40290(key), tag.method_10550("Duration"), tag.method_10550("Amplifier"), tag.method_10577("Ambient"), tag.method_10577("ShowParticles")));
            }
        }
        if (data.method_10573("Trinkets", 10)) {
            class_2487 slotData;
            class_2487 groupCompound;
            class_2487 trinketNbt = data.method_10562("Trinkets");
            for (String group : trinketNbt.method_10541()) {
                groupCompound = trinketNbt.method_10562(group);
                for (String slot : groupCompound.method_10541()) {
                    slotData = groupCompound.method_10562(slot);
                    if (!slotData.method_10573("Items", 9)) continue;
                    class_2499 class_24992 = slotData.method_10554("Items", 10);
                }
            }
            for (String group : trinketNbt.method_10541()) {
                groupCompound = trinketNbt.method_10562(group);
                for (String slot : groupCompound.method_10541()) {
                    slotData = groupCompound.method_10562(slot);
                    if (!slotData.method_10573("Items", 9)) continue;
                    class_2499 items = slotData.method_10554("Items", 10);
                    for (int i3 = 0; i3 < items.size(); ++i3) {
                        class_1799 stack;
                        class_2487 stackNbt = items.method_10602(i3);
                        if (!stackNbt.method_10545("id") || (stack = class_1799.field_24671.parse((DynamicOps)ops, (Object)stackNbt).result().orElse(class_1799.field_8037)).method_7960()) continue;
                        accessories.add(stack);
                    }
                }
            }
            if (trinketsLoaded) {
                TrinketsApi.getTrinketComponent((class_1309)fakePlayer).ifPresent(component -> {
                    class_5455.class_6890 registryLookup = client.method_1562().method_29091();
                    class_2487 trinketsOnlyNbt = new class_2487();
                    for (String group : trinketNbt.method_10541()) {
                        if (group.startsWith("accessories") || group.equals("data_written_by_accessories")) continue;
                        trinketsOnlyNbt.method_10566(group, trinketNbt.method_10580(group));
                    }
                    component.readFromNbt(trinketsOnlyNbt, (class_7225.class_7874)registryLookup);
                });
            }
        }
        for (int i4 = 0; i4 < 4; ++i4) {
            fakePlayer.method_31548().field_7548.set(i4, (Object)armorStacks[i4]);
        }
        fakePlayer.method_5673(class_1304.field_6169, armorStacks[3]);
        fakePlayer.method_5673(class_1304.field_6174, armorStacks[2]);
        fakePlayer.method_5673(class_1304.field_6172, armorStacks[1]);
        fakePlayer.method_5673(class_1304.field_6166, armorStacks[0]);
        fakePlayer.method_6122(class_1268.field_5808, mainHand);
        fakePlayer.method_6122(class_1268.field_5810, offHand);
        return new SnapshotData(fakePlayer, armorStacks, mainHand, offHand, accessories);
    }

    public record SnapshotData(class_745 player, class_1799[] armor, class_1799 mainHand, class_1799 offHand, List<class_1799> accessories) {
    }
}

