/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.pixeldreamstudios.showmeyourbuild.client.gui.BuildViewScreen;

@Environment(value=EnvType.CLIENT)
public class SlotRenderer {
    private static final int[][] ARMOR_SLOTS = new int[][]{{-57, -33}, {40, -33}, {-57, 20}, {40, 20}};
    private static final int[] MAIN_HAND_SLOT = new int[]{-90, -15};
    private static final int[] OFF_HAND_SLOT = new int[]{58, -15};
    private static final int HAND_SLOT_SIZE = 32;

    public static void renderSlots(class_332 context, class_1657 player, class_1657 snapshot, class_1799[] armorStacks, class_1799 mainHand, class_1799 offHand, int centerX, int centerY, class_327 textRenderer, int mouseX, int mouseY) {
        class_310 client = class_310.method_1551();
        for (int i = 0; i < 4; ++i) {
            int x = centerX + ARMOR_SLOTS[i][0];
            int y = centerY + ARMOR_SLOTS[i][1];
            context.method_25290(BuildViewScreen.SLOT_BACKGROUND, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            class_1799 stack = snapshot != null && armorStacks != null ? armorStacks[3 - i] : (class_1799)player.method_31548().field_7548.get(3 - i);
            context.method_51427(stack, x, y);
            context.method_51431(textRenderer, stack, x, y);
            if (mouseX < x || mouseX >= x + 16 || mouseY < y || mouseY >= y + 16) continue;
            if (!stack.method_7960()) {
                context.method_51446(textRenderer, stack, mouseX, mouseY);
                continue;
            }
            String slotName = SlotRenderer.slotNameForArmor(3 - i);
            context.method_51438(textRenderer, (class_2561)class_2561.method_43470((String)(slotName + " (Empty)")), mouseX, mouseY);
        }
        int mx = centerX + MAIN_HAND_SLOT[0];
        int my = centerY + MAIN_HAND_SLOT[1];
        context.method_25290(BuildViewScreen.SLOT_BACKGROUND, mx, my, 0.0f, 0.0f, 32, 32, 32, 32);
        context.method_51427(mainHand, mx + 8, my + 8);
        context.method_51431(textRenderer, mainHand, mx + 8, my + 8);
        if (mouseX >= mx && mouseX < mx + 32 && mouseY >= my && mouseY < my + 32) {
            if (!mainHand.method_7960()) {
                context.method_51446(textRenderer, mainHand, mouseX, mouseY);
            } else {
                context.method_51438(textRenderer, (class_2561)class_2561.method_43470((String)"Main Hand (Empty)"), mouseX, mouseY);
            }
        }
        mx = centerX + OFF_HAND_SLOT[0];
        my = centerY + OFF_HAND_SLOT[1];
        context.method_25290(BuildViewScreen.SLOT_BACKGROUND, mx, my, 0.0f, 0.0f, 32, 32, 32, 32);
        context.method_51427(offHand, mx + 8, my + 8);
        context.method_51431(textRenderer, offHand, mx + 8, my + 8);
        if (mouseX >= mx && mouseX < mx + 32 && mouseY >= my && mouseY < my + 32) {
            if (!offHand.method_7960()) {
                context.method_51446(textRenderer, offHand, mouseX, mouseY);
            } else {
                context.method_51438(textRenderer, (class_2561)class_2561.method_43470((String)"Offhand (Empty)"), mouseX, mouseY);
            }
        }
    }

    private static String slotNameForArmor(int index) {
        return switch (index) {
            case 0 -> "Boots Slot";
            case 1 -> "Leggings Slot";
            case 2 -> "Chestplate Slot";
            case 3 -> "Helmet Slot";
            default -> "Armor Slot";
        };
    }
}

