/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer.stats;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1320;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.AttributeOverrideRegistry;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatGroup;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatRow;

public class AttributeGroupFactory {
    private static final Set<String> excludedNamespaces = new HashSet<String>();
    private static final Set<class_2960> excludedAttributes = new HashSet<class_2960>();

    public static void excludeModNamespace(String namespace) {
        excludedNamespaces.add(namespace);
    }

    public static void excludeAttribute(class_2960 attributeId) {
        excludedAttributes.add(attributeId);
    }

    public static List<StatGroup> buildAttributeGroups(class_2487 attributesNbt) {
        HashMap<String, StatGroup> namespaceGroups = new HashMap<String, StatGroup>();
        for (String key : attributesNbt.method_10541()) {
            class_2960 icon;
            class_1320 attribute;
            double finalVal;
            class_2487 attrNbt;
            class_2960 id;
            if (key.startsWith("effect:") || (id = class_2960.method_12829((String)key)) == null || excludedNamespaces.contains(id.method_12836()) || excludedAttributes.contains(id) || AttributeOverrideRegistry.isAttributeHidden(id) || !(attrNbt = attributesNbt.method_10562(key)).method_10545("Final") || Double.isNaN(finalVal = attrNbt.method_10574("Final")) || (attribute = (class_1320)class_7923.field_41190.method_10223(id)) == null) continue;
            AttributeOverrideRegistry.AttributeOverride override = AttributeOverrideRegistry.getAttributeOverride(id);
            String label = override != null && override.label() != null ? override.label() : class_2561.method_43471((String)attribute.method_26830()).getString();
            String tooltip = override != null && override.tooltip() != null ? override.tooltip() : class_2561.method_43471((String)attribute.method_26830()).getString();
            class_2960 class_29602 = icon = override != null ? override.icon() : null;
            String namespace = id.method_12836();
            if (AttributeOverrideRegistry.isGroupHidden(namespace)) continue;
            AttributeOverrideRegistry.GroupOverride groupOverride = AttributeOverrideRegistry.getGroupOverride(namespace);
            String groupLabel = groupOverride != null && groupOverride.label() != null ? groupOverride.label() : AttributeGroupFactory.capitalize(namespace);
            class_2960 groupIcon = groupOverride != null ? groupOverride.icon() : null;
            String groupTooltip = groupOverride != null && groupOverride.tooltip() != null ? groupOverride.tooltip() : groupLabel + " Attributes";
            StatGroup group2 = namespaceGroups.computeIfAbsent(groupLabel, lbl -> new StatGroup(groupIcon, groupLabel, null, false, groupTooltip, -1));
            String value = AttributeGroupFactory.formatValue(finalVal);
            group2.addChild(new StatRow(icon, label, value, tooltip, true, group2.column, finalVal - attrNbt.method_10574("Base")));
        }
        for (StatGroup group3 : namespaceGroups.values()) {
            group3.getChildren().sort(Comparator.comparingDouble(r -> -Math.abs(r.getDelta())));
        }
        ArrayList<StatGroup> result = new ArrayList<StatGroup>(namespaceGroups.values());
        result.sort(Comparator.comparing(group -> group.tooltip));
        return result;
    }

    private static String formatValue(double val) {
        if (Math.floor(val) == val) {
            return String.format("%.0f", val);
        }
        return String.format("%.2f", val);
    }

    private static String capitalize(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(namespace.charAt(0)) + namespace.substring(1);
    }
}

