/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer.stats;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatGroup;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatRow;

public class SpellStatsFactory {
    private static final class_2960 GROUP_ICON = class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/generic.png");
    private static final Map<String, class_2960> ICONS = new HashMap<String, class_2960>();
    private static final Set<String> PERCENT_KEYS;

    public static StatGroup createFromAttributes(class_2487 attributesNbt) {
        StatGroup group = new StatGroup(GROUP_ICON, "Spell Power", "", false, "Spell Power", -1);
        for (String key : attributesNbt.method_10541()) {
            double finalVal;
            if (!key.startsWith("spell_power:") || Double.isNaN(finalVal = SpellStatsFactory.getFinal(attributesNbt, key))) continue;
            double baseVal = SpellStatsFactory.getBase(attributesNbt, key);
            double delta = finalVal - baseVal;
            String tooltip = SpellStatsFactory.getTooltipLabel(key);
            class_2960 icon = ICONS.getOrDefault(key, GROUP_ICON);
            String valueStr = SpellStatsFactory.formatValue(key, finalVal);
            group.addChild(new StatRow(icon, "", valueStr, tooltip, true, 0, delta));
        }
        group.getChildren().sort(Comparator.comparingDouble(r -> -Math.abs(r.getDelta())));
        return group;
    }

    private static double getFinal(class_2487 nbt, String key) {
        if (!nbt.method_10545(key)) {
            return Double.NaN;
        }
        class_2487 compound = nbt.method_10562(key);
        return compound.method_10545("Final") ? compound.method_10574("Final") : Double.NaN;
    }

    private static double getBase(class_2487 nbt, String key) {
        if (!nbt.method_10545(key)) {
            return 0.0;
        }
        class_2487 compound = nbt.method_10562(key);
        return compound.method_10545("Base") ? compound.method_10574("Base") : 0.0;
    }

    private static String formatValue(String key, double val) {
        if (PERCENT_KEYS.contains(key)) {
            return "%+.0f%%".formatted(val - 100.0);
        }
        return val == (double)((int)val) ? "%+.0f".formatted(val) : "%+.1f".formatted(val);
    }

    private static String getTooltipLabel(String attrId) {
        String key = attrId.contains(":") ? attrId.split(":")[1] : attrId;
        return SpellStatsFactory.capitalize(key.replace('_', ' '));
    }

    private static String capitalize(String input) {
        String[] words = input.split(" ");
        StringBuilder result = new StringBuilder();
        for (String w : words) {
            if (w.isEmpty()) continue;
            result.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public static void registerIcon(String attributeId, class_2960 icon) {
        ICONS.put(attributeId, icon);
    }

    static {
        ICONS.put("spell_power", GROUP_ICON);
        ICONS.put("spell_power:fire", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/fire.png"));
        ICONS.put("spell_power:frost", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/frost.png"));
        ICONS.put("spell_power:arcane", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/arcane.png"));
        ICONS.put("spell_power:soul", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/soul.png"));
        ICONS.put("spell_power:lightning", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/lightning.png"));
        ICONS.put("spell_power:critical_chance", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/critical_chance.png"));
        ICONS.put("spell_power:critical_damage", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/critical_damage.png"));
        ICONS.put("spell_power:haste", class_2960.method_60655((String)"spell_power", (String)"textures/mob_effect/haste.png"));
        PERCENT_KEYS = Set.of("spell_power:haste", "spell_power:critical_chance", "spell_power:critical_damage");
    }
}

