/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer.stats;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.CustomStatsLayoutRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatEntry;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatGroup;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatsViewRenderer;

@Environment(value=EnvType.CLIENT)
public class StatBoxRenderer {
    private static final int ENTRY_HEIGHT = 18;
    private static final int COLUMN_GAP = 10;
    private static final int ENTRIES_PER_COLUMN = 4;
    private static float scrollY = 0.0f;
    private static final List<RenderedEntry> rendered = new ArrayList<RenderedEntry>();

    public static void renderContents(class_332 ctx, class_327 tr, int x, int y, int mouseX, int mouseY, class_2487 attributes) {
        CustomStatsLayoutRenderer.render(ctx, tr, x, y, mouseX, mouseY, attributes);
        rendered.clear();
        List<StatEntry> entries = StatsViewRenderer.getVisibleEntries();
        int layoutOffsetY = y + 32;
        int columnWidth = 100;
        int leftX = x;
        int rightX = x + columnWidth + 10;
        int scrollIndex = (int)Math.floor(scrollY / 18.0f);
        int leftRendered = 0;
        int rightRendered = 0;
        for (StatEntry entry : entries) {
            int rowInCol;
            int col = entry.column % 2;
            int n = rowInCol = col == 0 ? leftRendered : rightRendered;
            if (rowInCol < scrollIndex) {
                if (col == 0) {
                    ++leftRendered;
                    continue;
                }
                ++rightRendered;
                continue;
            }
            if (col == 0 && leftRendered - scrollIndex >= 4 || col == 1 && rightRendered - scrollIndex >= 4) continue;
            int drawX = col == 0 ? leftX : rightX;
            int drawY = layoutOffsetY + 18 * (rowInCol - scrollIndex);
            entry.render(ctx, tr, drawX, drawY);
            entry.renderTooltip(ctx, tr, mouseX, mouseY, drawX, drawY, scrollY);
            rendered.add(new RenderedEntry(entry, drawX, drawY, 100, 18));
            if (col == 0) {
                ++leftRendered;
                continue;
            }
            ++rightRendered;
        }
    }

    public static void scroll(double amount) {
        scrollY = (float)((double)scrollY - amount * 18.0);
        List<StatEntry> entries = StatsViewRenderer.getVisibleEntries();
        int leftCount = 0;
        int rightCount = 0;
        for (StatEntry entry : entries) {
            if (entry.column % 2 == 0) {
                ++leftCount;
                continue;
            }
            ++rightCount;
        }
        int maxScrollRows = Math.max(leftCount, rightCount) - 4;
        float maxScroll = Math.max(0, maxScrollRows * 18);
        scrollY = Math.max(0.0f, Math.min(scrollY, maxScroll));
    }

    public static void resetScroll() {
        scrollY = 0.0f;
    }

    public static void handleClick(int mouseX, int mouseY, int originX, int originY) {
        for (RenderedEntry r : rendered) {
            StatEntry statEntry;
            if (mouseX < r.x || mouseX > r.x + r.width || mouseY < r.y || mouseY > r.y + r.height || !((statEntry = r.entry) instanceof StatGroup)) continue;
            StatGroup group = (StatGroup)statEntry;
            group.toggle();
            StatsViewRenderer.refreshExpandedEntries();
            return;
        }
    }

    private record RenderedEntry(StatEntry entry, int x, int y, int width, int height) {
    }
}

