/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer.stats;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.pixeldreamstudios.attributepanel.api.AttributePanelAPI;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.AttributeGroupFactory;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.SpellStatsFactory;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatBoxRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatEntry;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatGroup;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatGroupColumnAssigner;
import net.pixeldreamstudios.showmeyourbuild.util.ModCompat;

@Environment(value=EnvType.CLIENT)
public class StatsViewRenderer {
    private static boolean isSnapshot = false;
    private static final int BOX_WIDTH = 250;
    private static final int BOX_HEIGHT = 135;
    private static final int CLIP_MARGIN = 20;
    private static final boolean DEBUG = false;
    private static class_1657 liveTargetPlayer = null;
    private static final List<StatEntry> rawEntries = new ArrayList<StatEntry>();
    private static final List<StatEntry> visibleEntries = new ArrayList<StatEntry>();
    private static class_2487 currentAttributes = new class_2487();

    public static void setLiveTargetPlayer(class_1657 player) {
        liveTargetPlayer = player;
    }

    public static class_2487 getCurrentAttributes() {
        return currentAttributes;
    }

    public static void render(class_332 context, int centerX, int centerY, class_327 tr, int mouseX, int mouseY) {
        int x = centerX - 125;
        int y = centerY - 67 + 20;
        int clipX = x + 20;
        int clipY = y + 10;
        if (!isSnapshot && ModCompat.ATTRIBUTE_PANEL_LOADED) {
            class_1657 target;
            Object object = target = liveTargetPlayer != null ? liveTargetPlayer : class_310.method_1551().field_1724;
            if (target != null) {
                StatsViewRenderer.loadAttributes(AttributePanelAPI.getAttributeSnapshot((class_1657)target), false);
            }
        }
        if (rawEntries.isEmpty()) {
            StatsViewRenderer.initializeAttributeGroups();
        }
        StatsViewRenderer.refreshExpandedEntries();
        context.method_25303(tr, "Stats", centerX - tr.method_1727("Stats") / 2, centerY - 55, 0xAAAAAA);
        StatBoxRenderer.renderContents(context, tr, clipX, clipY, mouseX, mouseY, currentAttributes);
    }

    public static void loadAttributes(class_2487 attributesNbt, boolean snapshot) {
        currentAttributes = attributesNbt.method_10553();
        isSnapshot = snapshot;
        if (snapshot) {
            liveTargetPlayer = null;
        }
        StatsViewRenderer.initializeAttributeGroups();
    }

    public static void loadAttributes(class_2487 attributesNbt) {
        StatsViewRenderer.loadAttributes(attributesNbt, false);
    }

    public static void handleScroll(double amount) {
        StatBoxRenderer.scroll(amount);
    }

    public static void handleClick(int mouseX, int mouseY, int centerX, int centerY) {
        int x = centerX - 125;
        int y = centerY - 67 + 20;
        int clipX = x + 20;
        int clipY = y + 10;
        StatBoxRenderer.handleClick(mouseX, mouseY, clipX, clipY);
    }

    public static List<StatEntry> getVisibleEntries() {
        return visibleEntries;
    }

    public static void refreshExpandedEntries() {
        visibleEntries.clear();
        for (StatEntry entry : rawEntries) {
            StatGroup group;
            visibleEntries.add(entry);
            if (!(entry instanceof StatGroup) || !(group = (StatGroup)entry).isExpanded()) continue;
            visibleEntries.addAll(group.getChildren());
        }
    }

    private static void initializeAttributeGroups() {
        HashSet<String> expandedLabels = new HashSet<String>();
        for (StatEntry entry : rawEntries) {
            StatGroup group;
            if (!(entry instanceof StatGroup) || !(group = (StatGroup)entry).isExpanded()) continue;
            expandedLabels.add(group.getLabel());
        }
        rawEntries.clear();
        AttributeGroupFactory.excludeModNamespace("puffish_attributes");
        AttributeGroupFactory.excludeModNamespace("spell_power");
        AttributeGroupFactory.excludeAttribute(class_2960.method_60655((String)"some_mod", (String)"some_attribute"));
        if (currentAttributes != null && !currentAttributes.method_33133()) {
            StatGroup spellGroup;
            StatGroupColumnAssigner columnAssigner = new StatGroupColumnAssigner();
            if (ModCompat.SPELLPOWER_LOADED && !(spellGroup = SpellStatsFactory.createFromAttributes(currentAttributes)).getChildren().isEmpty()) {
                spellGroup.column = columnAssigner.assignColumn(spellGroup);
                spellGroup.propagateColumnToChildren();
                spellGroup.setExpanded(expandedLabels.contains(spellGroup.getLabel()));
                rawEntries.add(spellGroup);
            }
            List<StatGroup> groups = AttributeGroupFactory.buildAttributeGroups(currentAttributes);
            for (StatGroup group : groups) {
                group.column = columnAssigner.assignColumn(group);
                group.propagateColumnToChildren();
                group.setExpanded(expandedLabels.contains(group.getLabel()));
                rawEntries.add(group);
            }
        }
        StatsViewRenderer.refreshExpandedEntries();
    }
}

