/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.network;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.pixeldreamstudios.showmeyourbuild.network.BuildDataSerializer;
import net.pixeldreamstudios.showmeyourbuild.network.SkillTreeDataSerializer;
import net.pixeldreamstudios.showmeyourbuild.network.payload.OpenSkillsPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.RequestLiveEffectsPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.RequestSendBuildPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.RequestSkillTreePayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.SendBuildSnapshotPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.SendLiveEffectsPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.SendSkillTreeSnapshotPayload;
import net.pixeldreamstudios.showmeyourbuild.util.ModCompat;

public class ServerNetwork {
    public static void register() {
        PayloadTypeRegistry.playS2C().register(SendLiveEffectsPayload.ID, SendLiveEffectsPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestSendBuildPayload.ID, RequestSendBuildPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(OpenSkillsPayload.ID, OpenSkillsPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestLiveEffectsPayload.ID, RequestLiveEffectsPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestSkillTreePayload.ID, RequestSkillTreePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SendSkillTreeSnapshotPayload.ID, SendSkillTreeSnapshotPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SendBuildSnapshotPayload.ID, SendBuildSnapshotPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestSendBuildPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.player().field_13995.execute(() -> {
                class_2487 data = BuildDataSerializer.serialize((class_1657)player);
                if (ModCompat.PUFFISH_LOADED) {
                    class_2487 skillTreeData = SkillTreeDataSerializer.serialize((class_1657)player);
                    data.method_10566("Skills", (class_2520)skillTreeData);
                }
                for (class_3222 p : player.field_13995.method_3760().method_14571()) {
                    String snapshotId = UUID.randomUUID().toString();
                    ServerPlayNetworking.send((class_3222)p, (class_8710)new SendBuildSnapshotPayload(snapshotId, player.method_5477().getString(), data));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestLiveEffectsPayload.ID, (payload, context) -> {
            String targetName = payload.targetName();
            class_3222 requester = context.player();
            requester.field_13995.execute(() -> {
                class_3222 target = requester.field_13995.method_3760().method_14566(targetName);
                if (target != null) {
                    class_2487 data = new class_2487();
                    class_2499 potionList = BuildDataSerializer.serialize((class_1657)target).method_10554("PotionEffects", 10);
                    data.method_10566("PotionEffects", (class_2520)potionList);
                    ServerPlayNetworking.send((class_3222)requester, (class_8710)new SendLiveEffectsPayload(targetName, data));
                } else {
                    requester.method_7353((class_2561)class_2561.method_43470((String)("Could not find player: " + targetName)), false);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestSkillTreePayload.ID, (payload, context) -> {
            class_3222 requester = context.player();
            String targetName = payload.targetName();
            requester.field_13995.execute(() -> {
                class_3222 target = requester.field_13995.method_3760().method_14566(targetName);
                if (target != null) {
                    class_2487 skillTreeNbt = SkillTreeDataSerializer.serialize((class_1657)target);
                    SendSkillTreeSnapshotPayload response = new SendSkillTreeSnapshotPayload(target.method_5477().getString(), skillTreeNbt);
                    ServerPlayNetworking.send((class_3222)requester, (class_8710)response);
                } else {
                    requester.method_7353((class_2561)class_2561.method_43470((String)("Could not find player: " + targetName)), false);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(OpenSkillsPayload.ID, (payload, context) -> {
            String targetName = payload.targetName();
            class_3222 requester = context.player();
            requester.field_13995.execute(() -> {
                class_3222 target = requester.field_13995.method_3760().method_14566(targetName);
                if (target != null) {
                    class_2487 skillTreeNbt = SkillTreeDataSerializer.serialize((class_1657)target);
                    SendSkillTreeSnapshotPayload response = new SendSkillTreeSnapshotPayload(target.method_5477().getString(), skillTreeNbt);
                    ServerPlayNetworking.send((class_3222)requester, (class_8710)response);
                } else {
                    requester.method_7353((class_2561)class_2561.method_43470((String)("Could not find player: " + targetName)), false);
                }
            });
        });
    }
}

