/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import cyb0124.curvy_pipes.client.ClientMenu;
import cyb0124.curvy_pipes.common.BaseMenu;
import cyb0124.curvy_pipes.compat.JEIPlugin;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class BaseScreen
extends AbstractContainerScreen<BaseMenu> {
    private static boolean TRY_EMI = true;
    private static boolean TRY_REI = true;
    private static boolean TRY_JEI = true;
    public boolean draggingEmiGhost;
    private Object hovered;
    private boolean editBoxDirty;
    private int hintX;
    private int hintY;

    public BaseScreen(BaseMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        ((ClientMenu)((Object)menu)).init(this);
    }

    private Slot fakeSlot(final ItemStack stack, int x, int y) {
        return new Slot(this, null, -1, x, y){

            public ItemStack getItem() {
                return stack;
            }
        };
    }

    private EditBox newEditBox() {
        EditBox result = new EditBox(Minecraft.getInstance().font, 0, 0, 0, 0, (Component)Component.empty());
        result.setResponder(value -> {
            this.editBoxDirty = true;
        });
        result.setMaxLength(Integer.MAX_VALUE);
        result.setBordered(false);
        return result;
    }

    private void drawFluidIcon(GuiGraphics gui, net.neoforged.neoforge.fluids.FluidStack stack, float x, float y) {
        Fluid fluid = stack.getFluid();
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation loc = props.getStillTexture(stack);
        if (loc == null) {
            loc = MissingTextureAtlasSprite.getLocation();
        }
        ResourceLocation atlas = InventoryMenu.BLOCK_ATLAS;
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas(atlas).apply(loc);
        int tint = props.getTintColor(stack);
        float a = (float)(tint >> 24 & 0xFF) / 255.0f;
        float r = (float)(tint >> 16 & 0xFF) / 255.0f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f;
        float b = (float)(tint & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlas);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        Matrix4f pose = gui.pose().last().pose();
        BufferBuilder vb = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vb.addVertex(pose, x, y, 0.0f).setUv(sprite.getU0(), sprite.getV0());
        vb.addVertex(pose, x, y + 16.0f, 0.0f).setUv(sprite.getU0(), sprite.getV1());
        vb.addVertex(pose, x + 16.0f, y + 16.0f, 0.0f).setUv(sprite.getU1(), sprite.getV1());
        vb.addVertex(pose, x + 16.0f, y, 0.0f).setUv(sprite.getU1(), sprite.getV0());
        BufferUploader.drawWithShader((MeshData)vb.build());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFluidTooltip(GuiGraphics gui, net.neoforged.neoforge.fluids.FluidStack fluid, int mx, int my) {
        if (TRY_EMI) {
            try {
                List list = EmiStack.of((Fluid)fluid.getFluid(), (DataComponentPatch)fluid.getComponentsPatch(), (long)1L).getTooltip();
                EmiRenderHelper.drawTooltip((Screen)this, (EmiDrawContext)EmiDrawContext.wrap((GuiGraphics)gui), (List)list, (int)mx, (int)my);
                return;
            }
            catch (NoClassDefFoundError ignored) {
                TRY_EMI = false;
            }
        }
        if (TRY_REI) {
            try {
                EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)FluidStack.create((Fluid)fluid.getFluid(), (long)1L, (DataComponentPatch)fluid.getComponentsPatch())).getTooltip(TooltipContext.of((Point)new Point(mx, my), (Item.TooltipContext)Item.TooltipContext.EMPTY)).queue();
                return;
            }
            catch (NoClassDefFoundError ignored) {
                TRY_REI = false;
            }
        }
        if (TRY_JEI) {
            try {
                JeiTooltip tooltip = new JeiTooltip();
                ((IPlatformFluidHelperInternal)JEIPlugin.runtime.getJeiHelpers().getPlatformFluidHelper()).getTooltip((ITooltipBuilder)tooltip, (Object)fluid, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
                tooltip.draw(gui, mx, my);
                return;
            }
            catch (NoClassDefFoundError ignored) {
                TRY_JEI = false;
            }
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(fluid.getHoverName());
        if (this.minecraft.options.advancedItemTooltips) {
            ResourceLocation loc = fluid.getFluidHolder().getKey().location();
            lines.add(Component.literal((String)loc.toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        gui.renderComponentTooltip(this.font, lines, mx, my);
    }

    public void render(GuiGraphics gui, int mx, int my, float dt) {
        ((ClientMenu)this.getMenu()).preRender(this);
        super.render(gui, mx, my, dt);
        this.draggingEmiGhost = false;
        Object object = this.hovered;
        if (object instanceof Slot) {
            Slot slot;
            this.hoveredSlot = slot = (Slot)object;
        } else {
            object = this.hovered;
            if (object instanceof net.neoforged.neoforge.fluids.FluidStack) {
                net.neoforged.neoforge.fluids.FluidStack fluid = (net.neoforged.neoforge.fluids.FluidStack)object;
                this.drawFluidTooltip(gui, fluid, mx, my);
            } else {
                object = this.hovered;
                if (object instanceof FormattedCharSequence[]) {
                    FormattedCharSequence[] lines = (FormattedCharSequence[])object;
                    gui.renderTooltip(this.font, Arrays.asList(lines), (sw, sh, x, y, tw, th) -> new Vector2i(x, y), this.hintX, this.hintY + 6);
                }
            }
        }
        this.hovered = null;
        this.renderTooltip(gui, mx, my);
    }

    public boolean keyPressed(int key, int scan, int modifiers) {
        return ((ClientMenu)this.menu).onKey(this, key, scan, -1, modifiers) || super.keyPressed(key, scan, modifiers);
    }

    public boolean charTyped(char cp, int modifiers) {
        return ((ClientMenu)this.menu).onKey(this, -1, -1, cp, modifiers) || super.charTyped(cp, modifiers);
    }

    protected void renderBg(GuiGraphics gui, float dt, int mx, int my) {
        ((ClientMenu)this.menu).renderBg(this, gui, mx, my);
        gui.flush();
    }

    public boolean mouseClicked(double mx, double my, int which) {
        return ((ClientMenu)this.menu).onMouse(this, mx, my, which, true) || super.mouseClicked(mx, my, which);
    }

    public boolean mouseReleased(double mx, double my, int which) {
        return ((ClientMenu)this.menu).onMouse(this, mx, my, which, false) || super.mouseReleased(mx, my, which);
    }

    protected void renderLabels(GuiGraphics gui, int mx, int my) {
    }

    public static void onRegister(RegisterMenuScreensEvent evt) {
        evt.register(BaseMenu.TYPE, BaseScreen::new);
    }
}

