/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import cyb0124.curvy_pipes.Mod;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public abstract class BaseMenu
extends AbstractContainerMenu {
    public static MenuType<BaseMenu> TYPE;
    private Inventory playerInv;

    private static native BaseMenu open(byte[] var0);

    private native void init(int var1);

    private BaseMenu(int id) {
        super(TYPE, id);
    }

    private Slot[] playerInvSlots() {
        for (int i = 0; i < 36; ++i) {
            this.addSlot(new Slot((Container)this.playerInv, i < 27 ? i + 9 : i - 27, 0, 0));
        }
        return (Slot[])this.slots.toArray(Slot[]::new);
    }

    private Component playerInvName() {
        return this.playerInv.getDisplayName();
    }

    private static void open(ServerPlayer player, final BaseMenu menu, byte[] data) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"curvy_pipes.title");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                menu.playerInv = inv;
                menu.init(id);
                return menu;
            }
        }, buf -> buf.writeByteArray(data));
    }

    public ItemStack quickMoveStack(Player player, int idx) {
        Slot slot = this.getSlot(idx);
        ItemStack stack = slot.getItem();
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int oldCount = stack.getCount();
        if (idx < 27) {
            this.moveItemStackTo(stack, 27, 36, false);
        } else {
            this.moveItemStackTo(stack, 0, 27, false);
        }
        if (stack.getCount() == oldCount) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return stack;
    }

    public static void register(Registry<MenuType<?>> reg) {
        if (TYPE != null) {
            return;
        }
        TYPE = IMenuTypeExtension.create((id, inv, data) -> {
            try {
                BaseMenu menu = BaseMenu.open(data.readByteArray());
                menu.playerInv = inv;
                menu.init(id);
                return menu;
            }
            catch (Throwable e) {
                Mod.LOGGER.error("Failed to create menu", e);
                throw e;
            }
        });
        Registry.register(reg, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curvy_pipes", (String)"0"), TYPE);
    }
}

