/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import cyb0124.curvy_pipes.Mod;
import cyb0124.curvy_pipes.common.BaseMenu;
import cyb0124.curvy_pipes.common.ClientResources;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.RegisterEvent;

public class CommonHandler {
    private static native void loadConfig(String var0);

    private static native void registerItems(Registry<Item> var0);

    private static native Item[] creativeTabItems();

    public static native void idMapped();

    private static native void loadLevel(ServerLevel var0, String var1, byte[] var2, ChunkMap var3, SavedData var4);

    private static native void unloadLevel(ServerLevel var0);

    private static native byte[] saveLevel(ServerLevel var0);

    private static native void chunkLoaded(ServerLevel var0, int var1, int var2);

    private static native void chunkUnloaded(ServerLevel var0, int var1, int var2);

    private static native void watchChunk(ServerLevel var0, ServerPlayer var1, int var2, int var3);

    private static native void unwatchChunk(ServerPlayer var0, int var1, int var2);

    private static native void tick();

    private static native String[] getRecipes();

    static native String[] itemModelIDs();

    private static native int useItem(int var0, boolean var1, boolean var2);

    private static native int getSignal(ServerLevel var0, int var1, int var2, int var3, int var4, int var5);

    public static void loadResources(Map<String, FallbackResourceManager> out, PackType type) {
        if (type != PackType.CLIENT_RESOURCES) {
            return;
        }
        FallbackResourceManager mgr = out.get("curvy_pipes");
        if (mgr == null) {
            return;
        }
        mgr.push((PackResources)new ClientResources());
    }

    public static void applyRecipes(Map<ResourceLocation, JsonElement> out) {
        Gson gson = new Gson();
        String[] recipes = CommonHandler.getRecipes();
        for (int i = 0; i != recipes.length; i += 2) {
            try {
                ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)"curvy_pipes", (String)recipes[i]);
                JsonElement recipe = (JsonElement)gson.fromJson(recipes[i + 1], JsonElement.class);
                out.put(name, recipe);
                continue;
            }
            catch (Throwable e) {
                Mod.LOGGER.error("Failed to apply recipe " + recipes[i], e);
            }
        }
    }

    private static void queueWorker(Runnable task) {
        ForkJoinPool.commonPool().execute(task);
    }

    public static double[] getShapeBoxes(VoxelShape shape) {
        DoubleArrayList boxes = new DoubleArrayList();
        shape.forAllBoxes((xn, yn, zn, xp, yp, zp) -> {
            boxes.add(xn);
            boxes.add(yn);
            boxes.add(zn);
            boxes.add(xp);
            boxes.add(yp);
            boxes.add(zp);
        });
        return boxes.toDoubleArray();
    }

    private static void offsetBoxes(BlockPos pos, double[] boxes) {
        int i = 0;
        while (i != boxes.length) {
            int n = i++;
            boxes[n] = boxes[n] + (double)pos.getX();
            int n2 = i++;
            boxes[n2] = boxes[n2] + (double)pos.getY();
            int n3 = i++;
            boxes[n3] = boxes[n3] + (double)pos.getZ();
        }
    }

    public static double[] getCollisionBoxes(BlockPos pos, BlockState state, Level level) {
        double[] boxes = CommonHandler.getShapeBoxes(state.getCollisionShape((BlockGetter)level, pos));
        CommonHandler.offsetBoxes(pos, boxes);
        return boxes;
    }

    public static double[] getOutlineBoxes(BlockPos pos, BlockState state, Level level) {
        double[] boxes = CommonHandler.getShapeBoxes(state.getShape((BlockGetter)level, pos));
        CommonHandler.offsetBoxes(pos, boxes);
        return boxes;
    }

    private static double[] getCollisionBoxes(ServerLevel level, int cx, int cz, int x, int y, int z) {
        LevelChunk chunk = level.getChunkSource().getChunkNow(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getCollisionBoxes(pos, chunk.getBlockState(pos), (Level)level);
    }

    private static double[] getOutlineBoxes(ServerLevel level, int cx, int cz, int x, int y, int z) {
        LevelChunk chunk = level.getChunkSource().getChunkNow(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getOutlineBoxes(pos, chunk.getBlockState(pos), (Level)level);
    }

    public static boolean checkInstabuild(Player player) {
        return player.getAbilities().instabuild;
    }

    private static boolean isHoldingWrench(Player player) {
        return player.getMainHandItem().is(Tags.Items.TOOLS_WRENCH) || player.getOffhandItem().is(Tags.Items.TOOLS_WRENCH);
    }

    public static Stack<ItemStack> gatherStacks(Player player, Item item) {
        Inventory inv = player.getInventory();
        Stack<ItemStack> result = new Stack<ItemStack>();
        ItemStack selected = inv.getSelected();
        if (selected.is(item)) {
            result.add(selected);
        }
        for (ItemStack stack : inv.items) {
            if (stack == selected || !stack.is(item)) continue;
            result.add(stack);
        }
        for (ItemStack stack : inv.offhand) {
            if (!stack.is(item)) continue;
            result.add(stack);
        }
        return result;
    }

    public static int countStacks(Stack<ItemStack> stacks) {
        return stacks.stream().mapToInt(ItemStack::getCount).sum();
    }

    private static void consumeStacks(Player player, Stack<ItemStack> stacks, int count) {
        while (count != 0) {
            ItemStack top = stacks.peek();
            int avail = Math.min(top.getCount(), count);
            top.shrink(avail);
            if (top.isEmpty()) {
                stacks.pop();
            }
            count -= avail;
        }
        player.containerMenu.broadcastChanges();
    }

    private static void giveStack(Player player, Item item, int qty) {
        ItemStack stack = new ItemStack((ItemLike)item, qty);
        if (player.addItem(stack)) {
            player.containerMenu.broadcastChanges();
        }
        if (!stack.isEmpty()) {
            player.drop(stack, true);
        }
    }

    private static void spawnStack(ServerLevel level, Item item, int qty, double x, double y, double z) {
        ItemEntity entity = new ItemEntity((Level)level, x, y, z, new ItemStack((ItemLike)item, qty));
        entity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)entity);
    }

    public static int itemId(ItemStack stack) {
        return Item.getId((Item)stack.getItem());
    }

    private static String itemLoc(ItemStack stack) {
        return stack.getItemHolder().getKey().location().toString();
    }

    private static int itemPatchHash(ItemStack stack) {
        return stack.isComponentsPatchEmpty() ? 0 : stack.getComponentsPatch().hashCode();
    }

    private static long fluidAndPatchCatenatedHash(FluidStack stack) {
        long result = stack.getFluid().hashCode();
        return stack.isComponentsPatchEmpty() ? result : result << 32 | (long)stack.getComponentsPatch().hashCode();
    }

    private static FluidStack copyFluidWithQty(FluidStack stack, int qty) {
        stack = stack.copy();
        stack.setAmount(qty);
        return stack;
    }

    private static byte[] encodeItem(Level level, ItemStack stack) throws IOException {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        NbtIo.writeAnyTag((Tag)stack.save((HolderLookup.Provider)level.registryAccess()), (DataOutput)data);
        return data.toByteArray();
    }

    private static ItemStack decodeItem(Level level, byte[] data) throws IOException {
        return (ItemStack)ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)NbtIo.readAnyTag((DataInput)ByteStreams.newDataInput((byte[])data), (NbtAccounter)NbtAccounter.unlimitedHeap())).get();
    }

    private static byte[] encodeFluid(Level level, FluidStack stack) throws IOException {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        NbtIo.writeAnyTag((Tag)stack.save((HolderLookup.Provider)level.registryAccess()), (DataOutput)data);
        return data.toByteArray();
    }

    private static FluidStack decodeFluid(Level level, byte[] data) throws IOException {
        return (FluidStack)FluidStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)NbtIo.readAnyTag((DataInput)ByteStreams.newDataInput((byte[])data), (NbtAccounter)NbtAccounter.unlimitedHeap())).get();
    }

    private static FluidStack fluidOfItem(ItemStack stack) {
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            int numTanks = cap.getTanks();
            for (int i = 0; i != numTanks; ++i) {
                FluidStack fluid = cap.getFluidInTank(i);
                if (fluid.isEmpty()) continue;
                return fluid;
            }
        }
        return null;
    }

    public static <T> T resolveCap(BlockCapability<T, Direction> cap, ServerLevel level, int x, int y, int z, byte dir) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!level.isLoaded(pos)) {
            return null;
        }
        return (T)level.getCapability(cap, pos, (Object)Direction.from3DDataValue((int)dir));
    }

    private static IItemHandler resolveItemCap(ServerLevel level, int x, int y, int z, byte dir) {
        return (IItemHandler)CommonHandler.resolveCap(Capabilities.ItemHandler.BLOCK, level, x, y, z, dir);
    }

    private static IFluidHandler resolveFluidCap(ServerLevel level, int x, int y, int z, byte dir) {
        return (IFluidHandler)CommonHandler.resolveCap(Capabilities.FluidHandler.BLOCK, level, x, y, z, dir);
    }

    private static IEnergyStorage resolveEnergyCap(ServerLevel level, int x, int y, int z, byte dir) {
        return (IEnergyStorage)CommonHandler.resolveCap(Capabilities.EnergyStorage.BLOCK, level, x, y, z, dir);
    }

    private static ItemCapData readItemCap(IItemHandler cap) {
        ItemCapData result = new ItemCapData();
        int nSlots = cap.getSlots();
        result.slots = new int[nSlots * 2];
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = cap.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemPatchHash(stack));
            int oldSize = itemMap.size();
            result.slots[i * 2] = itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            result.slots[i * 2 + 1] = stack.getCount();
        }
        int size = itemMap.size();
        result.stacks = new ItemStack[size];
        result.hashes = new int[size * 2];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            result.stacks[i] = hashed.stack.copyWithCount(1);
            result.hashes[i * 2] = hashed.id;
            result.hashes[i * 2 + 1] = hashed.patchHash;
            ++i;
        }
        return result;
    }

    private static FluidCapData readFluidCap(IFluidHandler cap) {
        FluidCapData result = new FluidCapData();
        int nTanks = cap.getTanks();
        result.hashes = new long[nTanks * 2];
        result.stacks = new FluidStack[nTanks];
        for (int i = 0; i != nTanks; ++i) {
            FluidStack stack = cap.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            result.hashes[i * 2] = CommonHandler.fluidAndPatchCatenatedHash(stack);
            result.hashes[i * 2 + 1] = stack.getAmount();
            result.stacks[i] = CommonHandler.copyFluidWithQty(stack, 1);
        }
        return result;
    }

    public static int getSignal(int base, SignalGetter pLevel, BlockPos pos, Direction dir) {
        if (base >= 15) {
            return base;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return base;
        }
        ServerLevel level = (ServerLevel)pLevel;
        Block wire = Blocks.REDSTONE_WIRE;
        if (!wire.defaultBlockState().isSignalSource()) {
            return base;
        }
        return Math.max(base, CommonHandler.getSignal(level, System.identityHashCode(level), pos.getX(), pos.getY(), pos.getZ(), dir.get3DDataValue()));
    }

    private static int getSignal(ServerLevel level, int x, int y, int z, byte dir) {
        BlockPos pos = new BlockPos(x, y, z);
        int signal = level.getSignal(new BlockPos(x, y, z), Direction.from3DDataValue((int)dir));
        if (signal >= 14) {
            return signal;
        }
        BlockState state = level.getBlockState(pos);
        if (!state.is(Blocks.REDSTONE_WIRE)) {
            return signal;
        }
        return Math.max(signal, (Integer)state.getValue((Property)RedStoneWireBlock.POWER) - 1);
    }

    private static void updateNeighbors(ServerLevel level, int x0, int y0, int z0, int x1, int y1, int z1) {
        BlockPos p0 = new BlockPos(x0, y0, z0);
        BlockPos p1 = new BlockPos(x1, y1, z1);
        level.neighborChanged(p0, level.getBlockState(p1).getBlock(), p1);
        level.updateNeighborsAt(p0, level.getBlockState(p0).getBlock());
    }

    public static void onLevelLoad(LevelEvent.Load evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        final ServerLevel level = (ServerLevel)levelAccessor;
        Supplier<SavedData> newData = () -> new SavedData(){

            public CompoundTag save(CompoundTag tag, HolderLookup.Provider tags) {
                tag.putByteArray("0", CommonHandler.saveLevel(level));
                return tag;
            }
        };
        byte[][] bytes = new byte[][]{null};
        SavedData data = level.getDataStorage().computeIfAbsent(new SavedData.Factory(newData, (tag, tags) -> {
            bytes[0] = tag.getByteArray("0");
            return (SavedData)newData.get();
        }), "curvy_pipes");
        CommonHandler.loadLevel(level, level.dimension().location().toString(), bytes[0], level.getChunkSource().chunkMap, data);
    }

    private static long[] scanChunks(Long2ObjectMap<ChunkHolder> chunks) {
        int level = ChunkLevel.byStatus((ChunkStatus)ChunkStatus.FULL);
        LongArrayList result = new LongArrayList();
        for (Long2ObjectMap.Entry entry : chunks.long2ObjectEntrySet()) {
            if (((ChunkHolder)entry.getValue()).getTicketLevel() > level) continue;
            result.add(entry.getLongKey());
        }
        return result.toLongArray();
    }

    public static void onChunkLoad(ChunkEvent.Load evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkPos pos = evt.getChunk().getPos();
        CommonHandler.chunkLoaded(level, pos.x, pos.z);
    }

    public static void onChunkUnload(ChunkEvent.Unload evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkPos pos = evt.getChunk().getPos();
        CommonHandler.chunkUnloaded(level, pos.x, pos.z);
    }

    public static void onLevelUnload(LevelEvent.Unload evt) {
        ServerLevel level;
        LevelAccessor levelAccessor = evt.getLevel();
        CommonHandler.unloadLevel(levelAccessor instanceof ServerLevel ? (level = (ServerLevel)levelAccessor) : null);
    }

    public static void onChunkWatch(ChunkWatchEvent.Watch evt) {
        ChunkPos pos = evt.getPos();
        CommonHandler.watchChunk(evt.getLevel(), evt.getPlayer(), pos.x, pos.z);
    }

    public static void onChunkUnwatch(ChunkWatchEvent.UnWatch evt) {
        ChunkPos pos = evt.getPos();
        CommonHandler.unwatchChunk(evt.getPlayer(), pos.x, pos.z);
    }

    public static void loadConfig() {
        String config;
        String defaultConfig;
        Path defaultPath = FMLPaths.CONFIGDIR.get().resolve("curvy_pipes_default.yaml");
        Path path = FMLPaths.CONFIGDIR.get().resolve("curvy_pipes.yaml");
        try (InputStream is = Mod.class.getResourceAsStream("/default.yaml");){
            defaultConfig = new String(is.readAllBytes());
            Files.writeString(defaultPath, (CharSequence)defaultConfig, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            config = Files.readString(path);
        }
        catch (IOException e) {
            config = defaultConfig;
        }
        CommonHandler.loadConfig(config);
    }

    public static void onRegister(RegisterEvent evt) {
        Registry regItems = evt.getRegistry(Registries.ITEM);
        if (regItems != null) {
            CommonHandler.registerItems((Registry<Item>)regItems);
            return;
        }
        Registry regTabs = evt.getRegistry(Registries.CREATIVE_MODE_TAB);
        if (regTabs != null) {
            Item[] items = CommonHandler.creativeTabItems();
            if (items != null) {
                CreativeModeTab tab = CreativeModeTab.builder().title((Component)Component.translatable((String)"curvy_pipes.title")).icon(() -> new ItemStack((ItemLike)items[0])).displayItems((params, out) -> {
                    for (int i = 1; i != items.length; ++i) {
                        out.accept((ItemLike)items[i]);
                    }
                }).build();
                Registry.register((Registry)regTabs, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curvy_pipes", (String)"creative_tab"), (Object)tab);
            }
            return;
        }
        Registry regMenus = evt.getRegistry(Registries.MENU);
        if (regMenus != null) {
            BaseMenu.register(regMenus);
        }
    }

    public static void onCommonSetup(FMLCommonSetupEvent ignored) {
        CommonHandler.idMapped();
    }

    public static void onTick(ServerTickEvent.Post ignored) {
        CommonHandler.tick();
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (CommonHandler.useItem(CommonHandler.itemId(evt.getItemStack()), evt.getHand() == InteractionHand.OFF_HAND, false) != 0) {
            evt.setUseItem(TriState.FALSE);
        }
    }

    public static void onRightClickItem(PlayerInteractEvent.RightClickItem evt) {
        int result = CommonHandler.useItem(CommonHandler.itemId(evt.getItemStack()), evt.getHand() == InteractionHand.OFF_HAND, evt.getLevel().isClientSide);
        if (result != 0) {
            evt.setCanceled(true);
            evt.setCancellationResult(result == 1 ? InteractionResult.CONSUME : InteractionResult.FAIL);
        }
    }

    private static class ItemCapData {
        private int[] slots;
        private int[] hashes;
        private ItemStack[] stacks;

        private ItemCapData() {
        }
    }

    private record HashedStack(ItemStack stack, int id, int patchHash) {
        @Override
        public int hashCode() {
            return 31 * (31 + this.id) + this.patchHash;
        }

        @Override
        public boolean equals(Object o) {
            return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)((HashedStack)o).stack);
        }
    }

    private static class FluidCapData {
        private long[] hashes;
        private FluidStack[] stacks;

        private FluidCapData() {
        }
    }
}

