/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import cyb0124.curvy_pipes.client.BaseScreen;
import cyb0124.curvy_pipes.client.MiscRenderTypes;
import cyb0124.curvy_pipes.common.BaseMenu;
import cyb0124.curvy_pipes.common.CommonHandler;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;

public class ClientHandler {
    private static boolean TRY_IRIS = true;
    static final FloatBuffer TRANSFORMS = BufferUtils.createFloatBuffer((int)41);
    static BufferBuilder.RenderedBuffer MESH;

    private static native void loadSprites(TextureAtlas var0);

    static native void renderPipeItem(int var0, int var1, int var2, int var3);

    private static native void renderLevel(double var0, double var2, double var4, boolean var6, boolean var7, int var8, int var9, int var10, int var11, double var12, float var14, int var15, int var16);

    private static native void renderTranslucent();

    private static native void renderGui(GuiGraphics var0);

    private static native void tick();

    private static native boolean interact(HitResult var0, boolean var1);

    private static BufferBuilder.DrawState makeDrawState(int nVertices, int nIndices, int format) {
        return new BufferBuilder.DrawState(switch (format) {
            case 0 -> DefaultVertexFormat.f_85812_;
            case 1 -> DefaultVertexFormat.f_85811_;
            case 2 -> DefaultVertexFormat.f_85815_;
            default -> DefaultVertexFormat.f_85817_;
        }, nVertices, nIndices, VertexFormat.Mode.TRIANGLES, VertexFormat.IndexType.INT, false, false);
    }

    private static boolean disableIrisFormat() {
        boolean wasExtended = false;
        if (TRY_IRIS) {
            try {
                wasExtended = ImmediateState.renderWithExtendedVertexFormat;
                ImmediateState.renderWithExtendedVertexFormat = false;
            }
            catch (NoClassDefFoundError ignored) {
                TRY_IRIS = false;
            }
        }
        return wasExtended;
    }

    private static VertexBuffer makeBuffer() {
        boolean wasExtended = ClientHandler.disableIrisFormat();
        VertexBuffer vb = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vb.m_85921_();
        vb.m_231221_(MESH);
        VertexBuffer.m_85931_();
        if (wasExtended) {
            ImmediateState.renderWithExtendedVertexFormat = true;
        }
        return vb;
    }

    private static void drawBuffer(VertexBuffer vb) {
        RenderType type = MiscRenderTypes.ENTITY_CUTOUT_MIPPED;
        type.m_110185_();
        vb.m_85921_();
        TRANSFORMS.position(0);
        Matrix4f proj = new Matrix4f(TRANSFORMS);
        TRANSFORMS.position(16);
        Matrix4f pose = new Matrix4f(TRANSFORMS);
        float oldFog = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        vb.m_253207_(pose, proj, RenderSystem.getShader());
        RenderSystem.setShaderFogStart((float)oldFog);
        VertexBuffer.m_85931_();
        type.m_110188_();
    }

    private static void drawImmediate(RenderType type) {
        boolean wasExtended = ClientHandler.disableIrisFormat();
        type.m_110185_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)MESH);
        type.m_110188_();
        if (wasExtended) {
            ImmediateState.renderWithExtendedVertexFormat = true;
        }
    }

    private static void drawImmediate(int type) {
        ClientHandler.drawImmediate(switch (type) {
            case 0 -> MiscRenderTypes.ENTITY_CUTOUT_MIPPED;
            case 1 -> Sheets.m_110792_();
            default -> MiscRenderTypes.GUI_NO_CULL;
        });
    }

    private static void drawCrumble(float pct) {
        int n = ModelBakery.f_119229_.size();
        ClientHandler.drawImmediate((RenderType)ModelBakery.f_119229_.get(Math.min((int)(pct * (float)n), n - 1)));
    }

    private static void spawnPipeEffects(double[] coords, SoundEvent sound, Consumer<Vec3> makeParticle) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        Vec3 bestPos = null;
        double bestDist = 0.0;
        int i = 0;
        while (i != coords.length) {
            Vec3 pos = new Vec3(coords[i++], coords[i++], coords[i++]);
            double dist = pos.m_82557_(mc.f_91074_.m_20182_());
            if (bestPos == null || dist < bestDist) {
                bestPos = pos;
                bestDist = dist;
            }
            makeParticle.accept(pos);
        }
        mc.f_91073_.m_7785_(bestPos.f_82479_, bestPos.f_82480_, bestPos.f_82481_, sound, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }

    private static void spawnBreakEffects(double[] coords, final float u0, final float v0, final float u1, final float v1, float r, float g, float b) {
        ClientHandler.spawnPipeEffects(coords, SoundEvents.f_12442_, pos -> {
            Minecraft mc = Minecraft.m_91087_();
            TerrainParticle particle = new TerrainParticle(mc.f_91073_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, Blocks.f_50069_.m_49966_()){
                final float uRand;
                final float vRand;
                {
                    super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
                    this.uRand = this.f_107223_.m_188501_() * 3.0f;
                    this.vRand = this.f_107223_.m_188501_() * 3.0f;
                }

                protected float m_5970_() {
                    return u0 + (u1 - u0) * (this.uRand + 1.0f) / 4.0f;
                }

                protected float m_5951_() {
                    return v0 + (v1 - v0) * this.vRand / 4.0f;
                }

                protected float m_5952_() {
                    return u0 + (u1 - u0) * this.uRand / 4.0f;
                }

                protected float m_5950_() {
                    return v0 + (v1 - v0) * (this.vRand + 1.0f) / 4.0f;
                }
            };
            particle.m_107253_(r, g, b);
            mc.f_91061_.m_107344_((Particle)particle);
        });
    }

    private static void spawnBurnEffects(double[] coords) {
        ClientHandler.spawnPipeEffects(coords, SoundEvents.f_12031_, pos -> Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 5.0E-5, 0.0));
    }

    private static void swingHand() {
        Minecraft.m_91087_().f_91074_.m_6674_(InteractionHand.MAIN_HAND);
    }

    private static int queryLight(int x, int y, int z) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos pos = new BlockPos(x, y, z);
        int block = level.m_45517_(LightLayer.BLOCK, pos);
        int sky = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)block, (int)sky);
    }

    private static boolean queryLight(int[] data) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int i = 0;
        while (i != data.length) {
            int sky;
            BlockPos pos;
            int block;
            if (LightTexture.m_109885_((int)(block = level.m_45517_(LightLayer.BLOCK, pos = new BlockPos(data[i++], data[i++], data[i++]))), (int)(sky = level.m_45517_(LightLayer.SKY, pos))) == data[i++]) continue;
            return true;
        }
        return false;
    }

    private static int countStacks(Item item) {
        return CommonHandler.countStacks(CommonHandler.gatherStacks((Player)Minecraft.m_91087_().f_91074_, item));
    }

    private static String dim() {
        return Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().toString();
    }

    private static void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    private static double[] getOutlineBoxes(int x, int y, int z) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getOutlineBoxes(pos, level.m_8055_(pos), (Level)level);
    }

    private static double[] getExtOutlineBoxes(int x0, int y0, int z0) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        DoubleArrayList boxes = new DoubleArrayList();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    int x = x0 + i;
                    int y = y0 + j;
                    int z = z0 + k;
                    BlockPos pos = new BlockPos(x, y, z);
                    level.m_8055_(pos).m_60808_((BlockGetter)level, pos).m_83286_((xn, yn, zn, xp, yp, zp) -> {
                        boxes.add(xn + (double)x);
                        boxes.add(yn + (double)y);
                        boxes.add(zn + (double)z);
                        boxes.add(xp + (double)x);
                        boxes.add(yp + (double)y);
                        boxes.add(zp + (double)z);
                    });
                }
            }
        }
        return boxes.toDoubleArray();
    }

    private static void batchText(GuiGraphics gui, FormattedCharSequence text, float x, float y, int color, boolean shadow) {
        Minecraft.m_91087_().f_91062_.m_272191_(text, x, y, color, shadow, gui.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)gui.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderLevel(RenderLevelStageEvent evt) {
        RenderLevelStageEvent.Stage stage = evt.getStage();
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            Minecraft mc = Minecraft.m_91087_();
            Window fb = mc.m_91268_();
            ItemStack mainHand = ItemStack.f_41583_;
            ItemStack offHand = ItemStack.f_41583_;
            if (mc.f_91074_ != null) {
                mainHand = mc.f_91074_.m_21205_();
                offHand = mc.f_91074_.m_21206_();
            }
            PoseStack.Pose pose = evt.getPoseStack().m_85850_();
            evt.getProjectionMatrix().get(0, TRANSFORMS);
            pose.m_252922_().get(16, TRANSFORMS);
            pose.m_252943_().get(32, TRANSFORMS);
            if (mc.f_91073_.m_104583_().m_108885_()) {
                Lighting.m_252995_((Matrix4f)pose.m_252922_());
            } else {
                Lighting.m_252756_((Matrix4f)pose.m_252922_());
            }
            boolean shadow = false;
            if (TRY_IRIS) {
                try {
                    shadow = ShadowRenderer.ACTIVE;
                }
                catch (NoClassDefFoundError ignored) {
                    TRY_IRIS = false;
                }
            }
            Vec3 eye = evt.getCamera().m_90583_();
            ClientHandler.renderLevel(eye.f_82479_, eye.f_82480_, eye.f_82481_, shadow, mc.f_91066_.f_92091_.m_90857_(), fb.m_85443_(), fb.m_85444_(), fb.m_85441_(), fb.m_85442_(), fb.m_85449_(), evt.getPartialTick(), CommonHandler.itemId(mainHand), CommonHandler.itemId(offHand));
        } else if (stage.equals(RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS)) {
            ClientHandler.renderTranslucent();
        }
    }

    public static void renderGui(RenderGuiEvent.Pre evt) {
        ClientHandler.renderGui(evt.getGuiGraphics());
    }

    public static void onStitch(TextureStitchEvent evt) {
        TextureAtlas atlas = evt.getAtlas();
        if (atlas.m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            ClientHandler.loadSprites(atlas);
        }
    }

    public static void onTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            ClientHandler.tick();
        }
    }

    public static void onInteract(InputEvent.InteractionKeyMappingTriggered evt) {
        if (!evt.isUseItem()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ != null && ClientHandler.interact(mc.f_91077_, mc.f_91066_.f_92090_.m_90857_())) {
            evt.setSwingHand(true);
            evt.setCanceled(true);
        }
    }

    public static void onClientSetup(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> MenuScreens.m_96206_(BaseMenu.TYPE, BaseScreen::new));
    }
}

