/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import cyb0124.curvy_pipes.Mod;
import cyb0124.curvy_pipes.common.BaseMenu;
import cyb0124.curvy_pipes.common.CauldronAdapter;
import cyb0124.curvy_pipes.common.ClientResources;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.RegisterEvent;

public class CommonHandler {
    private static final TagKey<Item> WRENCH = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge:tools/wrench"));

    private static native void loadConfig(String var0);

    private static native void registerItems(IForgeRegistry<Item> var0);

    private static native Item[] creativeTabItems();

    private static native void idMapped();

    private static native void loadLevel(ServerLevel var0, String var1, byte[] var2, ChunkMap var3, SavedData var4);

    private static native void unloadLevel(ServerLevel var0);

    private static native byte[] saveLevel(ServerLevel var0);

    private static native void chunkLoaded(ServerLevel var0, int var1, int var2);

    private static native void chunkUnloaded(ServerLevel var0, int var1, int var2);

    private static native void watchChunk(ServerLevel var0, ServerPlayer var1, int var2, int var3);

    private static native void unwatchChunk(ServerPlayer var0, int var1, int var2);

    private static native void tick();

    private static native String[] getRecipes();

    static native String[] itemModelIDs();

    private static native int useItem(int var0, boolean var1, boolean var2);

    private static native int getSignal(ServerLevel var0, int var1, int var2, int var3, int var4, int var5);

    public static void loadResources(Map<String, FallbackResourceManager> out, PackType type) {
        if (type != PackType.CLIENT_RESOURCES) {
            return;
        }
        FallbackResourceManager mgr = out.get("curvy_pipes");
        if (mgr == null) {
            return;
        }
        mgr.m_215377_((PackResources)new ClientResources());
    }

    public static void applyRecipes(Map<ResourceLocation, JsonElement> out) {
        Gson gson = new Gson();
        String[] recipes = CommonHandler.getRecipes();
        for (int i = 0; i != recipes.length; i += 2) {
            try {
                ResourceLocation name = new ResourceLocation("curvy_pipes", recipes[i]);
                JsonElement recipe = (JsonElement)gson.fromJson(recipes[i + 1], JsonElement.class);
                out.put(name, recipe);
                continue;
            }
            catch (Throwable e) {
                Mod.LOGGER.error("Failed to apply recipe " + recipes[i], e);
            }
        }
    }

    private static void queueWorker(Runnable task) {
        ForkJoinPool.commonPool().execute(task);
    }

    public static double[] getShapeBoxes(VoxelShape shape) {
        DoubleArrayList boxes = new DoubleArrayList();
        shape.m_83286_((xn, yn, zn, xp, yp, zp) -> {
            boxes.add(xn);
            boxes.add(yn);
            boxes.add(zn);
            boxes.add(xp);
            boxes.add(yp);
            boxes.add(zp);
        });
        return boxes.toDoubleArray();
    }

    private static void offsetBoxes(BlockPos pos, double[] boxes) {
        int i = 0;
        while (i != boxes.length) {
            int n = i++;
            boxes[n] = boxes[n] + (double)pos.m_123341_();
            int n2 = i++;
            boxes[n2] = boxes[n2] + (double)pos.m_123342_();
            int n3 = i++;
            boxes[n3] = boxes[n3] + (double)pos.m_123343_();
        }
    }

    public static double[] getCollisionBoxes(BlockPos pos, BlockState state, Level level) {
        double[] boxes = CommonHandler.getShapeBoxes(state.m_60812_((BlockGetter)level, pos));
        CommonHandler.offsetBoxes(pos, boxes);
        return boxes;
    }

    public static double[] getOutlineBoxes(BlockPos pos, BlockState state, Level level) {
        double[] boxes = CommonHandler.getShapeBoxes(state.m_60808_((BlockGetter)level, pos));
        CommonHandler.offsetBoxes(pos, boxes);
        return boxes;
    }

    private static double[] getCollisionBoxes(ServerLevel level, int cx, int cz, int x, int y, int z) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getCollisionBoxes(pos, chunk.m_8055_(pos), (Level)level);
    }

    private static double[] getOutlineBoxes(ServerLevel level, int cx, int cz, int x, int y, int z) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getOutlineBoxes(pos, chunk.m_8055_(pos), (Level)level);
    }

    public static boolean checkInstabuild(Player player) {
        return player.m_150110_().f_35937_;
    }

    private static boolean isHoldingWrench(Player player) {
        return player.m_21205_().m_204117_(WRENCH) || player.m_21206_().m_204117_(WRENCH);
    }

    public static Stack<ItemStack> gatherStacks(Player player, Item item) {
        Inventory inv = player.m_150109_();
        Stack<ItemStack> result = new Stack<ItemStack>();
        ItemStack selected = inv.m_36056_();
        if (selected.m_150930_(item)) {
            result.add(selected);
        }
        for (ItemStack stack : inv.f_35974_) {
            if (stack == selected || !stack.m_150930_(item)) continue;
            result.add(stack);
        }
        for (ItemStack stack : inv.f_35976_) {
            if (!stack.m_150930_(item)) continue;
            result.add(stack);
        }
        return result;
    }

    public static int countStacks(Stack<ItemStack> stacks) {
        return stacks.stream().mapToInt(ItemStack::m_41613_).sum();
    }

    private static void consumeStacks(Player player, Stack<ItemStack> stacks, int count) {
        while (count != 0) {
            ItemStack top = stacks.peek();
            int avail = Math.min(top.m_41613_(), count);
            top.m_41774_(avail);
            if (top.m_41619_()) {
                stacks.pop();
            }
            count -= avail;
        }
        player.f_36096_.m_38946_();
    }

    private static void giveStack(Player player, Item item, int qty) {
        ItemStack stack = new ItemStack((ItemLike)item, qty);
        if (player.m_36356_(stack)) {
            player.f_36096_.m_38946_();
        }
        if (!stack.m_41619_()) {
            player.m_36176_(stack, true);
        }
    }

    private static void spawnStack(ServerLevel level, Item item, int qty, double x, double y, double z) {
        ItemEntity entity = new ItemEntity((Level)level, x, y, z, new ItemStack((ItemLike)item, qty));
        entity.m_32060_();
        level.m_7967_((Entity)entity);
    }

    public static int itemId(ItemStack stack) {
        return Item.m_41393_((Item)stack.m_41720_());
    }

    private static String itemLoc(ItemStack stack) {
        return stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
    }

    private static int itemTagHash(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().hashCode() : 0;
    }

    private static long fluidAndTagCatenatedHash(FluidStack stack) {
        long result = stack.getFluid().hashCode();
        return stack.hasTag() ? result << 32 | (long)stack.getTag().hashCode() : result;
    }

    private static FluidStack copyFluidWithQty(FluidStack stack, int qty) {
        stack = stack.copy();
        stack.setAmount(qty);
        return stack;
    }

    private static byte[] encodeItem(ItemStack stack) throws IOException {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        NbtIo.m_128941_((CompoundTag)stack.serializeNBT(), (DataOutput)data);
        return data.toByteArray();
    }

    private static ItemStack decodeItem(byte[] data) throws IOException {
        return ItemStack.m_41712_((CompoundTag)NbtIo.m_128928_((DataInput)ByteStreams.newDataInput((byte[])data)));
    }

    private static byte[] encodeFluid(FluidStack stack) throws IOException {
        CompoundTag tag = new CompoundTag();
        stack.writeToNBT(tag);
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        NbtIo.m_128941_((CompoundTag)tag, (DataOutput)data);
        return data.toByteArray();
    }

    private static FluidStack decodeFluid(byte[] data) throws IOException {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)NbtIo.m_128928_((DataInput)ByteStreams.newDataInput((byte[])data)));
    }

    private static FluidStack fluidOfItem(ItemStack stack) {
        Optional result = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (result.isPresent()) {
            IFluidHandlerItem cap = (IFluidHandlerItem)result.get();
            int numTanks = cap.getTanks();
            for (int i = 0; i != numTanks; ++i) {
                FluidStack fluid = cap.getFluidInTank(i);
                if (fluid.isEmpty()) continue;
                return fluid;
            }
        }
        return null;
    }

    public static <T> T resolveCap(Capability<T> cap, ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockEntity tile = chunk.m_7702_(new BlockPos(x, y, z));
        if (tile == null) {
            return null;
        }
        return (T)tile.getCapability(cap, Direction.m_122376_((int)dir)).orElse(null);
    }

    private static IItemHandler resolveItemCap(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        return (IItemHandler)CommonHandler.resolveCap(ForgeCapabilities.ITEM_HANDLER, level, cx, cz, x, y, z, dir);
    }

    private static IFluidHandler resolveFluidCap(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockEntity tile = chunk.m_7702_(pos);
        if (tile != null) {
            return (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.m_122376_((int)dir)).orElse(null);
        }
        if (chunk.m_8055_(pos).m_60734_() instanceof AbstractCauldronBlock) {
            return new CauldronAdapter(chunk, pos);
        }
        return null;
    }

    private static IEnergyStorage resolveEnergyCap(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        return (IEnergyStorage)CommonHandler.resolveCap(ForgeCapabilities.ENERGY, level, cx, cz, x, y, z, dir);
    }

    private static ItemCapData readItemCap(IItemHandler cap) {
        ItemCapData result = new ItemCapData();
        int nSlots = cap.getSlots();
        result.slots = new int[nSlots * 2];
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = cap.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            result.slots[i * 2] = itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            result.slots[i * 2 + 1] = stack.m_41613_();
        }
        int size = itemMap.size();
        result.stacks = new ItemStack[size];
        result.hashes = new int[size * 2];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            result.stacks[i] = hashed.stack.m_255036_(1);
            result.hashes[i * 2] = hashed.id;
            result.hashes[i * 2 + 1] = hashed.tagHash;
            ++i;
        }
        return result;
    }

    private static FluidCapData readFluidCap(IFluidHandler cap) {
        FluidCapData result = new FluidCapData();
        int nTanks = cap.getTanks();
        result.hashes = new long[nTanks * 2];
        result.stacks = new FluidStack[nTanks];
        for (int i = 0; i != nTanks; ++i) {
            FluidStack stack = cap.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            result.hashes[i * 2] = CommonHandler.fluidAndTagCatenatedHash(stack);
            result.hashes[i * 2 + 1] = stack.getAmount();
            result.stacks[i] = CommonHandler.copyFluidWithQty(stack, 1);
        }
        return result;
    }

    public static int getSignal(int base, SignalGetter pLevel, BlockPos pos, Direction dir) {
        if (base >= 15) {
            return base;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return base;
        }
        ServerLevel level = (ServerLevel)pLevel;
        Block wire = Blocks.f_50088_;
        if (!wire.m_49966_().m_60803_()) {
            return base;
        }
        return Math.max(base, CommonHandler.getSignal(level, System.identityHashCode(level), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dir.m_122411_()));
    }

    private static int getSignal(ServerLevel level, int x, int y, int z, byte dir) {
        BlockPos pos = new BlockPos(x, y, z);
        int signal = level.m_277185_(new BlockPos(x, y, z), Direction.m_122376_((int)dir));
        if (signal >= 14) {
            return signal;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(Blocks.f_50088_)) {
            return signal;
        }
        return Math.max(signal, (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_) - 1);
    }

    private static void updateNeighbors(ServerLevel level, int x0, int y0, int z0, int x1, int y1, int z1) {
        BlockPos p0 = new BlockPos(x0, y0, z0);
        BlockPos p1 = new BlockPos(x1, y1, z1);
        level.m_46586_(p0, level.m_8055_(p1).m_60734_(), p1);
        level.m_46672_(p0, level.m_8055_(p0).m_60734_());
    }

    public static void onLevelLoad(LevelEvent.Load evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        final ServerLevel level = (ServerLevel)levelAccessor;
        Supplier<SavedData> newData = () -> new SavedData(){

            public CompoundTag m_7176_(CompoundTag tag) {
                tag.m_128382_("0", CommonHandler.saveLevel(level));
                return tag;
            }
        };
        byte[][] bytes = new byte[][]{null};
        SavedData data = level.m_8895_().m_164861_(tag -> {
            bytes[0] = tag.m_128463_("0");
            return (SavedData)newData.get();
        }, newData, "curvy_pipes");
        CommonHandler.loadLevel(level, level.m_46472_().m_135782_().toString(), bytes[0], level.m_7726_().f_8325_, data);
    }

    public static void onChunkLoad(ChunkEvent.Load evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkPos pos = evt.getChunk().m_7697_();
        CommonHandler.chunkLoaded(level, pos.f_45578_, pos.f_45579_);
    }

    public static void onChunkUnload(ChunkEvent.Unload evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkPos pos = evt.getChunk().m_7697_();
        CommonHandler.chunkUnloaded(level, pos.f_45578_, pos.f_45579_);
    }

    public static void onLevelUnload(LevelEvent.Unload evt) {
        ServerLevel level;
        LevelAccessor levelAccessor = evt.getLevel();
        CommonHandler.unloadLevel(levelAccessor instanceof ServerLevel ? (level = (ServerLevel)levelAccessor) : null);
    }

    public static void onChunkWatch(ChunkWatchEvent.Watch evt) {
        ChunkPos pos = evt.getPos();
        CommonHandler.watchChunk(evt.getLevel(), evt.getPlayer(), pos.f_45578_, pos.f_45579_);
    }

    public static void onChunkUnwatch(ChunkWatchEvent.UnWatch evt) {
        ChunkPos pos = evt.getPos();
        CommonHandler.unwatchChunk(evt.getPlayer(), pos.f_45578_, pos.f_45579_);
    }

    public static void loadConfig() {
        String config;
        String defaultConfig;
        Path defaultPath = FMLPaths.CONFIGDIR.get().resolve("curvy_pipes_default.yaml");
        Path path = FMLPaths.CONFIGDIR.get().resolve("curvy_pipes.yaml");
        try (InputStream is = Mod.class.getResourceAsStream("/default.yaml");){
            defaultConfig = new String(is.readAllBytes());
            Files.writeString(defaultPath, (CharSequence)defaultConfig, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            config = Files.readString(path);
        }
        catch (IOException e) {
            config = defaultConfig;
        }
        CommonHandler.loadConfig(config);
    }

    public static void onRegister(RegisterEvent evt) {
        ResourceKey key = evt.getRegistryKey();
        if (key.equals((Object)ForgeRegistries.Keys.ITEMS)) {
            CommonHandler.registerItems((IForgeRegistry<Item>)evt.getForgeRegistry());
        } else if (key.equals((Object)Registries.f_279569_)) {
            Item[] items = CommonHandler.creativeTabItems();
            if (items != null) {
                CreativeModeTab tab = CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"curvy_pipes.title")).m_257737_(() -> new ItemStack((ItemLike)items[0])).m_257501_((params, out) -> {
                    for (int i = 1; i != items.length; ++i) {
                        out.m_246326_((ItemLike)items[i]);
                    }
                }).m_257652_();
                Registry.m_122965_((Registry)evt.getVanillaRegistry(), (ResourceLocation)new ResourceLocation("curvy_pipes", "creative_tab"), (Object)tab);
            }
        } else if (key.equals((Object)ForgeRegistries.Keys.MENU_TYPES)) {
            BaseMenu.register(evt.getForgeRegistry());
        }
    }

    public static void onIdMap(IdMappingEvent ignored) {
        CommonHandler.idMapped();
    }

    public static void onCommonSetup(FMLCommonSetupEvent ignored) {
        CommonHandler.idMapped();
    }

    public static void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            CommonHandler.tick();
        }
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (CommonHandler.useItem(CommonHandler.itemId(evt.getItemStack()), evt.getHand() == InteractionHand.OFF_HAND, false) != 0) {
            evt.setUseItem(Event.Result.DENY);
        }
    }

    public static void onRightClickItem(PlayerInteractEvent.RightClickItem evt) {
        int result = CommonHandler.useItem(CommonHandler.itemId(evt.getItemStack()), evt.getHand() == InteractionHand.OFF_HAND, evt.getLevel().f_46443_);
        if (result != 0) {
            evt.setCanceled(true);
            evt.setCancellationResult(result == 1 ? InteractionResult.CONSUME : InteractionResult.FAIL);
        }
    }

    private static class ItemCapData {
        private int[] slots;
        private int[] hashes;
        private ItemStack[] stacks;

        private ItemCapData() {
        }
    }

    private record HashedStack(ItemStack stack, int id, int tagHash) {
        @Override
        public int hashCode() {
            return 31 * (31 + this.id) + this.tagHash;
        }

        @Override
        public boolean equals(Object o) {
            return ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)((HashedStack)o).stack);
        }
    }

    private static class FluidCapData {
        private long[] hashes;
        private FluidStack[] stacks;

        private FluidCapData() {
        }
    }
}

