/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import cyb0124.curvy_pipes.Mod;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetHandler {
    private static final String VERSION = "0";
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("curvy_pipes", "net"), () -> "0", "0"::equals, "0"::equals);

    private static native String handleC2S(ServerPlayer var0, byte[] var1);

    private static native String handleS2C(byte[] var0);

    public NetHandler() {
        this.channel.registerMessage(0, byte[].class, (msg, buf) -> buf.m_130087_(msg), FriendlyByteBuf::m_130052_, this::handle);
    }

    private void handle(byte[] msg, Supplier<NetworkEvent.Context> pCtx) {
        NetworkEvent.Context ctx = pCtx.get();
        ctx.setPacketHandled(true);
        if (ctx.getDirection().getOriginationSide().isClient()) {
            ServerPlayer player = ctx.getSender();
            ctx.enqueueWork(() -> {
                String error = NetHandler.handleC2S(player, msg);
                if (error != null) {
                    Mod.LOGGER.warn("Failed to handle packet from {}: {}", (Object)player.m_36316_().getName(), (Object)error);
                }
            });
        } else {
            ctx.enqueueWork(() -> {
                String error = NetHandler.handleS2C(msg);
                if (error != null) {
                    Mod.LOGGER.warn("Failed to handle packet from server: {}", (Object)error);
                }
            });
        }
    }

    private void sendToServer(byte[] msg) {
        this.channel.sendToServer((Object)msg);
    }

    private void sendToPlayer(ServerPlayer player, byte[] msg) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }
}

