/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEParts;
import appeng.me.energy.IEnergyOverlayGridConnection;
import appeng.me.service.EnergyService;
import cyb0124.curvy_pipes.compat.AEIconItem;
import java.util.Collections;
import java.util.Locale;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class AEPlugin {
    private static AEIconItem ICON_ITEM;

    private static native void addCable(int var0, int var1, String var2, Item var3, ResourceLocation var4);

    private static void addCable(int type, AEColor color, Item item, String sprite) {
        AEPlugin.addCable(type, color.whiteVariant, ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), item, new ResourceLocation("ae2", sprite));
    }

    private static void addCables() {
        AEPlugin.addCable(0, AEColor.TRANSPARENT, AEParts.QUARTZ_FIBER.m_5456_(), "part/quartz_fiber");
        for (AEColor color : AEColor.values()) {
            String suffix = color.name().toLowerCase(Locale.ROOT);
            AEPlugin.addCable(1, color, AEParts.GLASS_CABLE.item(color), "part/cable/glass/" + suffix);
            AEPlugin.addCable(2, color, AEParts.COVERED_CABLE.item(color), "part/cable/covered/" + suffix);
            AEPlugin.addCable(3, color, AEParts.SMART_CABLE.item(color), "part/cable/smart/" + suffix);
            AEPlugin.addCable(4, color, AEParts.COVERED_DENSE_CABLE.item(color), "part/cable/dense_covered/" + suffix);
            AEPlugin.addCable(5, color, AEParts.SMART_DENSE_CABLE.item(color), "part/cable/dense_smart/" + suffix);
        }
    }

    private static void registerIconItem(IForgeRegistry<Item> reg, String id) {
        if (ICON_ITEM == null) {
            ICON_ITEM = new AEIconItem();
        }
        reg.register(id, (Object)ICON_ITEM);
    }

    private static AEItemKey makeIconItem(Item pipe, boolean joint) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("pipe", pipe.m_204114_().m_205785_().m_135782_().toString());
        if (joint) {
            tag.m_128379_("joint", true);
        }
        return AEItemKey.of((ItemLike)ICON_ITEM, (CompoundTag)tag);
    }

    private static IManagedGridNode addNode(ServerLevel level, Item pipe, IntConsumer setOverlayIdx, byte capacity, boolean joint) {
        NodeOwner owner = new NodeOwner(setOverlayIdx);
        IManagedGridNode mNode = GridHelper.createManagedNode((Object)owner, (IGridNodeListener)owner);
        mNode.setIdlePowerUsage(0.0);
        GridFlags[] gridFlagsArray = new GridFlags[1];
        gridFlagsArray[0] = switch (capacity) {
            case 0 -> GridFlags.CANNOT_CARRY;
            case 1 -> GridFlags.PREFERRED;
            default -> GridFlags.DENSE_CAPACITY;
        };
        mNode.setFlags(gridFlagsArray);
        mNode.setVisualRepresentation(AEPlugin.makeIconItem(pipe, joint));
        mNode.create((Level)level, null);
        return mNode;
    }

    private static IManagedGridNode[] addEnergyPair(ServerLevel level, Item pipe) {
        NodeOwner owner = new NodeOwner(null);
        IManagedGridNode x = GridHelper.createManagedNode((Object)owner, (IGridNodeListener)owner);
        IManagedGridNode y = GridHelper.createManagedNode((Object)owner, (IGridNodeListener)owner);
        x.setIdlePowerUsage(0.0);
        y.setIdlePowerUsage(0.0);
        x.setFlags(new GridFlags[]{GridFlags.CANNOT_CARRY});
        y.setFlags(new GridFlags[]{GridFlags.CANNOT_CARRY});
        x.addService(IEnergyOverlayGridConnection.class, (IGridNodeService)((IEnergyOverlayGridConnection)() -> Collections.singletonList((EnergyService)y.getNode().getGrid().getService(IEnergyService.class))));
        y.addService(IEnergyOverlayGridConnection.class, (IGridNodeService)((IEnergyOverlayGridConnection)() -> Collections.singletonList((EnergyService)x.getNode().getGrid().getService(IEnergyService.class))));
        AEItemKey icon = AEPlugin.makeIconItem(pipe, false);
        x.setVisualRepresentation(icon);
        y.setVisualRepresentation(icon);
        x.create((Level)level, null);
        y.create((Level)level, null);
        return new IManagedGridNode[]{x, y};
    }

    private static void addNodeConn(IGridNode x, IGridNode y) {
        for (IGridConnection c : x.getConnections()) {
            if (c.a() != y && c.b() != y) continue;
            return;
        }
        GridHelper.createConnection((IGridNode)x, (IGridNode)y);
    }

    private static void addNodeConn(IManagedGridNode x, IManagedGridNode y) {
        AEPlugin.addNodeConn(x.getNode(), y.getNode());
    }

    private static void addBlockConn(IManagedGridNode mNode, ServerLevel level, int x, int y, int z, byte rawDir, boolean ext) {
        IGridNode peer;
        IPartHost parts;
        IPart part;
        BlockPos pos = new BlockPos(x, y, z);
        if (!level.m_46749_(pos)) {
            return;
        }
        IInWorldGridNodeHost host = GridHelper.getNodeHost((Level)level, (BlockPos)pos);
        if (host == null) {
            return;
        }
        Direction dir = Direction.m_122376_((int)rawDir);
        if (host instanceof IPartHost && (part = (parts = (IPartHost)host).getPart(dir)) != null) {
            IGridNode peer2;
            IGridNode iGridNode = peer2 = ext ? part.getExternalFacingNode() : part.getGridNode();
            if (peer2 != null) {
                AEPlugin.addNodeConn(mNode.getNode(), peer2);
                return;
            }
        }
        if ((peer = host.getGridNode(dir)) != null) {
            AEPlugin.addNodeConn(mNode.getNode(), peer);
        }
    }

    private static class NodeOwner
    implements IGridNodeListener<NodeOwner> {
        private final IntConsumer setOverlayIdx;
        private int lastOverlayIdx;

        private NodeOwner(IntConsumer setOverlayIdx) {
            this.setOverlayIdx = setOverlayIdx;
        }

        public void onSaveChanges(NodeOwner owner, IGridNode node) {
        }

        public void onStateChanged(NodeOwner owner, IGridNode node, IGridNodeListener.State state) {
            int overlayIdx;
            if (this.setOverlayIdx == null) {
                return;
            }
            int n = overlayIdx = node.isPowered() ? node.getUsedChannels() : 0;
            if (this.lastOverlayIdx == overlayIdx) {
                return;
            }
            this.lastOverlayIdx = overlayIdx;
            this.setOverlayIdx.accept(overlayIdx);
        }
    }
}

