/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.item.MaterialPipeBlockItem;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.block.FluidPipeBlock;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import cyb0124.curvy_pipes.compat.GTEnergyWrapper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;

public class GTPlugin {
    private static native void addCable(PipeMeta var0, boolean var1, WireProperties var2);

    private static native void addItemPipe(PipeMeta var0, float var1);

    private static native void addFluidPipe(PipeMeta var0, FluidPipeProperties var1, Predicate<FluidStack> var2);

    static native long acceptEnergy(ServerLevel var0, int var1, int var2, int var3, int var4, byte var5, long var6, long var8);

    static native boolean canAcceptEnergy(ServerLevel var0, int var1, int var2, int var3, int var4, byte var5);

    public static IEnergyContainer wrapEnergyContainer(IEnergyContainer inner, Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return inner;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return new GTEnergyWrapper(inner, serverLevel, pos);
    }

    private static EnergySink resolveEnergySink(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockEntity tile = chunk.m_7702_(new BlockPos(x, y, z));
        if (tile == null) {
            return null;
        }
        Direction dirObj = Direction.m_122376_((int)dir);
        LazyOptional cap = tile.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, Direction.m_122376_((int)dir));
        if (!cap.isPresent()) {
            return null;
        }
        return (volts, amps) -> {
            IEnergyContainer resolved = (IEnergyContainer)cap.orElse(null);
            if (resolved == null || !resolved.inputsEnergy(dirObj)) {
                return 0L;
            }
            return resolved.acceptEnergyFromNetwork(dirObj, volts, amps);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldBurn(FluidPipeProperties props, FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidType fluidType = fluid.getFluidType();
        int temp = fluidType.getTemperature(stack);
        if (props.getMaxFluidTemperature() < temp) return true;
        if (!props.isGasProof()) {
            if (fluidType.getDensity(stack) < 0) return true;
        }
        if (!props.isCryoProof()) {
            if (temp < 120) return true;
        }
        if (!(fluid instanceof GTFluid)) return false;
        GTFluid gtFluid = (GTFluid)fluid;
        if (!props.canContain(gtFluid.getState())) return true;
        if (gtFluid.getAttributes().stream().allMatch(arg_0 -> ((FluidPipeProperties)props).canContain(arg_0))) return false;
        return true;
    }

    public static void addPipe(MaterialPipeBlockItem item, int types) {
        MaterialPipeBlock block = item.getBlock();
        PipeMeta meta = new PipeMeta((Item)item, ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), block.model, block.material.getMaterialRGB());
        if (block instanceof CableBlock) {
            CableBlock cable = (CableBlock)block;
            if ((types & 1) == 0) {
                return;
            }
            GTPlugin.addCable(meta, ((Insulation)cable.pipeType).isCable, (WireProperties)cable.createProperties(block.m_49966_(), null));
        } else if (block instanceof ItemPipeBlock) {
            ItemPipeBlock pipe = (ItemPipeBlock)block;
            if ((types & 2) == 0) {
                return;
            }
            GTPlugin.addItemPipe(meta, ((ItemPipeProperties)pipe.createProperties(block.m_49966_(), null)).getTransferRate());
        } else if (block instanceof FluidPipeBlock) {
            FluidPipeBlock pipe = (FluidPipeBlock)block;
            if ((types & 4) == 0) {
                return;
            }
            FluidPipeProperties props = (FluidPipeProperties)pipe.createProperties(block.m_49966_(), null);
            if (props.getChannels() != 1) {
                return;
            }
            GTPlugin.addFluidPipe(meta, props, fluid -> GTPlugin.shouldBurn(props, fluid));
        }
    }

    private static interface EnergySink {
        public long sink(long var1, long var3);
    }

    private record PipeMeta(Item item, String id, PipeModel model, int rgb) {
    }
}

